/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.AbstractBaseCache;
import org.castor.cache.CacheAcquireException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLimited
extends AbstractBaseCache {
    private static final Log LOG = LogFactory.getLog(TimeLimited.class);
    public static final String TYPE = "time-limited";
    public static final String PARAM_TTL = "ttl";
    public static final int DEFAULT_TTL = 30;
    private static final int TICK_DELAY = 1;
    private static final int DEFAULT_PRECISION = 1000;
    private static final TickThread TIMER = new TickThread(1000);
    private Hashtable<Object, QueueItem> _map = new Hashtable();
    private int _ttl = 30;

    @Override
    public final void initialize(Properties params) throws CacheAcquireException {
        super.initialize(params);
        String param = params.getProperty(PARAM_TTL);
        try {
            if (param != null) {
                this._ttl = Integer.parseInt(param);
            }
            if (this._ttl <= 0) {
                this._ttl = 30;
            }
        }
        catch (NumberFormatException ex) {
            this._ttl = 30;
        }
        if (TIMER._list.contains(this)) {
            TIMER._list.remove(this);
            this._map.clear();
        }
        TIMER.addTickerTask(this);
    }

    @Override
    public final String getType() {
        return TYPE;
    }

    public final int getTTL() {
        return this._ttl;
    }

    @Override
    public final synchronized int size() {
        return this._map.size();
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public final synchronized boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public final synchronized boolean containsValue(Object value) {
        for (QueueItem item : this._map.values()) {
            if (!(value == null ? item._value == null : value.equals(item._value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public final synchronized Object get(Object key) {
        QueueItem item = this._map.get(key);
        return item == null ? null : item._value;
    }

    @Override
    public final synchronized Object put(Object key, Object value) {
        QueueItem item = this._map.get(key);
        if (item != null) {
            return item.update(value, this._ttl);
        }
        this._map.put(key, new QueueItem(key, value, this._ttl));
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        QueueItem item = this._map.remove(key);
        return item == null ? null : item._value;
    }

    @Override
    public final void putAll(Map<? extends Object, ? extends Object> map) {
        for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public final synchronized void clear() {
        this._map.clear();
    }

    @Override
    public final synchronized Set<Object> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public final synchronized Collection<Object> values() {
        ArrayList<Object> col = new ArrayList<Object>(this._map.size());
        for (QueueItem item : this._map.values()) {
            col.add(item._value);
        }
        return Collections.unmodifiableCollection(col);
    }

    @Override
    public final synchronized Set<Map.Entry<Object, Object>> entrySet() {
        Hashtable<Object, Object> map = new Hashtable<Object, Object>(this._map.size());
        for (Map.Entry<Object, QueueItem> entry : this._map.entrySet()) {
            QueueItem item = entry.getValue();
            map.put(entry.getKey(), item._value);
        }
        return Collections.unmodifiableSet(map.entrySet());
    }

    private synchronized void tick() {
        if (!this._map.isEmpty()) {
            Iterator<QueueItem> iter = this._map.values().iterator();
            while (iter.hasNext()) {
                QueueItem queueItem = iter.next();
                Object key = queueItem._key;
                if (queueItem._time <= 0) {
                    iter.remove();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.trace((Object)("dispose(" + key + ")"));
                    continue;
                }
                queueItem._time -= 1;
            }
        }
    }

    private static final class TickThread
    extends Thread {
        private ArrayList<TimeLimited> _list = new ArrayList();
        private int _tick;

        public TickThread(int tick) {
            super("Time-limited cache daemon");
            this.setDaemon(true);
            this.setPriority(1);
            this._tick = tick;
            this.start();
        }

        void addTickerTask(TimeLimited cache) {
            this._list.add(cache);
        }

        public void run() {
            try {
                long last = System.currentTimeMillis();
                block2: while (true) {
                    long diff;
                    if ((diff = System.currentTimeMillis() - last) < (long)this._tick) {
                        TickThread.sleep((long)this._tick - diff);
                    }
                    last = System.currentTimeMillis();
                    int i = 0;
                    while (true) {
                        if (i >= this._list.size()) continue block2;
                        this._list.get(i).tick();
                        ++i;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Time-limited cache daemon has been interrupted", (Throwable)e);
                return;
            }
        }
    }

    private final class QueueItem {
        private Object _key;
        private Object _value;
        private int _time;

        private QueueItem(Object key, Object value, int time) {
            this._key = key;
            this._value = value;
            this._time = time;
        }

        private Object update(Object value, int time) {
            Object oldValue = this._value;
            this._value = value;
            this._time = time;
            return oldValue;
        }
    }
}

