/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class HighLowKeyGenerator
implements KeyGenerator {
    private static final Log LOG = LogFactory.getLog(HighLowKeyGenerator.class);
    private static final String SEQ_TABLE = "table";
    private static final String SEQ_KEY = "key-column";
    private static final String SEQ_VALUE = "value-column";
    private static final String GRAB_SIZE = "grab-size";
    private static final String SAME_CONNECTION = "same-connection";
    private static final String GLOBAL = "global";
    private final Map _handlers = new HashMap();
    private final PersistenceFactory _factory;
    private final int _sqlType;
    private String _seqTable;
    private String _seqKey;
    private String _seqValue;
    private int _grabSize;
    private boolean _sameConnection;
    private boolean _global;

    public HighLowKeyGenerator(PersistenceFactory factory, Properties params, int sqlType) throws MappingException {
        this._factory = factory;
        this._sqlType = sqlType;
        this.supportsSqlType(sqlType);
        this.initFromParameters(params);
    }

    public void initFromParameters(Properties params) throws MappingException {
        this._seqTable = params.getProperty(SEQ_TABLE);
        if (this._seqTable == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_TABLE, this.getClass().getName()));
        }
        this._seqKey = params.getProperty(SEQ_KEY);
        if (this._seqKey == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_KEY, this.getClass().getName()));
        }
        this._seqValue = params.getProperty(SEQ_VALUE);
        if (this._seqValue == null) {
            throw new MappingException(Messages.format("mapping.KeyGenParamNotSet", SEQ_VALUE, this.getClass().getName()));
        }
        String grabSize = params.getProperty(GRAB_SIZE, "10");
        try {
            this._grabSize = Integer.parseInt(grabSize);
        }
        catch (NumberFormatException except) {
            this._grabSize = 0;
        }
        if (this._grabSize <= 0) {
            throw new MappingException(Messages.format("mapping.wrongKeyGenParam", grabSize, GRAB_SIZE, this.getClass().getName()));
        }
        this._sameConnection = "true".equals(params.getProperty(SAME_CONNECTION));
        this._global = "true".equals(params.getProperty(GLOBAL));
    }

    /*
     * Loose catch block
     */
    public synchronized Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        HighLowSqlTypeHandler handler;
        block25: {
            String internalTableName = tableName;
            if (this._global) {
                internalTableName = "<GLOBAL>";
            }
            if ((handler = (HighLowSqlTypeHandler)this._handlers.get(internalTableName)) == null) {
                handler = this._sqlType == 4 ? new HighLowIntegerSqlTypeHandler(internalTableName, this._grabSize) : (this._sqlType == -5 ? new HighLowLongSqlTypeHandler(internalTableName, this._grabSize) : new HighLowBigDecimalSqlTypeHandler(internalTableName, this._grabSize));
                this._handlers.put(internalTableName, handler);
            }
            if (!handler.hasNext()) {
                QueryExpression query = this._factory.getQueryExpression();
                query.addColumn(this._seqTable, this._seqValue);
                query.addCondition(this._seqTable, this._seqKey, "=", "?");
                String lockSQL = query.getStatement(true);
                String updateSQL = "UPDATE " + this._seqTable + " SET " + this._seqValue + "=" + "?" + " WHERE " + this._seqKey + "=" + "?" + " AND " + this._seqValue + "=" + "?";
                String maxSQL = "SELECT MAX(" + primKeyName + ") " + "FROM " + internalTableName;
                String insertSQL = "INSERT INTO " + this._seqTable + " (" + this._seqKey + "," + this._seqValue + ") VALUES (?, ?)";
                Statement stmt = null;
                if (!this._sameConnection) {
                    conn.rollback();
                }
                boolean success = false;
                for (int i = 0; !success && i < 7; ++i) {
                    stmt = conn.prepareStatement(lockSQL);
                    handler.bindTable((PreparedStatement)stmt, 1);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        handler.init(rs);
                        stmt.close();
                        stmt = conn.prepareStatement(updateSQL);
                        handler.bindMax((PreparedStatement)stmt, 1);
                        handler.bindTable((PreparedStatement)stmt, 2);
                        handler.bindLast((PreparedStatement)stmt, 3);
                    } else {
                        stmt.close();
                        if (this._global) {
                            handler.init(null);
                        } else {
                            stmt = conn.prepareStatement(maxSQL);
                            rs = stmt.executeQuery();
                            handler.init(rs);
                            stmt.close();
                        }
                        stmt = conn.prepareStatement(insertSQL);
                        handler.bindTable((PreparedStatement)stmt, 1);
                        handler.bindMax((PreparedStatement)stmt, 2);
                    }
                    success = stmt.executeUpdate() == 1;
                    stmt.close();
                }
                if (success) {
                    if (!this._sameConnection) {
                        conn.commit();
                    }
                } else {
                    if (!this._sameConnection) {
                        conn.rollback();
                    }
                    throw new PersistenceException(Messages.format("persist.keyGenFailed", this.getClass().getName()));
                }
                Object var17_18 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block25;
                }
                catch (SQLException ex) {
                    LOG.warn((Object)Messages.message("persist.stClosingFailed"), (Throwable)ex);
                }
                break block25;
                {
                    catch (SQLException ex) {
                        try {
                            if (!this._sameConnection) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException ex2) {
                            LOG.warn((Object)"Problem rolling back JDBC transaction.", (Throwable)ex2);
                        }
                        throw new PersistenceException(Messages.format("persist.keyGenSQL", this.getClass().getName(), ex.toString()), ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        LOG.warn((Object)Messages.message("persist.stClosingFailed"), (Throwable)ex);
                    }
                    throw throwable;
                }
            }
        }
        return handler.next();
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        if (sqlType != 4 && sqlType != -5 && sqlType != 2 && sqlType != 3) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public byte getStyle() {
        return -1;
    }

    public boolean isInSameConnection() {
        return this._sameConnection;
    }

    public String patchSQL(String insert, String primKeyName) {
        return insert;
    }

    private static class HighLowBigDecimalSqlTypeHandler
    implements HighLowSqlTypeHandler {
        private static final BigDecimal ZERO = new BigDecimal(0);
        private static final BigDecimal ONE = new BigDecimal(1);
        private final String _table;
        private final BigDecimal _grab;
        private BigDecimal _last = ZERO;
        private BigDecimal _max = ZERO;

        public HighLowBigDecimalSqlTypeHandler(String table, int grab) {
            this._table = table;
            this._grab = new BigDecimal(grab);
        }

        public void init(ResultSet rs) throws SQLException {
            this._last = null;
            if (rs != null && rs.isFirst()) {
                this._last = rs.getBigDecimal(1);
            }
            if (this._last == null) {
                this._last = ZERO;
            }
            this._max = this._last.add(this._grab);
        }

        public boolean hasNext() {
            return this._last.compareTo(this._max) < 0;
        }

        public Object next() {
            this._last = this._last.add(ONE);
            return this._last;
        }

        public void bindTable(PreparedStatement stmt, int index) throws SQLException {
            stmt.setString(index, this._table);
        }

        public void bindLast(PreparedStatement stmt, int index) throws SQLException {
            stmt.setBigDecimal(index, this._last);
        }

        public void bindMax(PreparedStatement stmt, int index) throws SQLException {
            stmt.setBigDecimal(index, this._max);
        }
    }

    private static class HighLowLongSqlTypeHandler
    implements HighLowSqlTypeHandler {
        private final String _table;
        private final long _grab;
        private long _last = 0L;
        private long _max = 0L;

        public HighLowLongSqlTypeHandler(String table, int grab) {
            this._table = table;
            this._grab = grab;
        }

        public void init(ResultSet rs) throws SQLException {
            this._last = 0L;
            if (rs != null && rs.isFirst()) {
                this._last = rs.getLong(1);
            }
            this._max = this._last + this._grab;
        }

        public boolean hasNext() {
            return this._last < this._max;
        }

        public Object next() {
            return new Long(++this._last);
        }

        public void bindTable(PreparedStatement stmt, int index) throws SQLException {
            stmt.setString(index, this._table);
        }

        public void bindLast(PreparedStatement stmt, int index) throws SQLException {
            stmt.setLong(index, this._last);
        }

        public void bindMax(PreparedStatement stmt, int index) throws SQLException {
            stmt.setLong(index, this._max);
        }
    }

    private static class HighLowIntegerSqlTypeHandler
    implements HighLowSqlTypeHandler {
        private final String _table;
        private final int _grab;
        private int _last = 0;
        private int _max = 0;

        public HighLowIntegerSqlTypeHandler(String table, int grab) {
            this._table = table;
            this._grab = grab;
        }

        public void init(ResultSet rs) throws SQLException {
            this._last = 0;
            if (rs != null && rs.isFirst()) {
                this._last = rs.getInt(1);
            }
            this._max = this._last + this._grab;
        }

        public boolean hasNext() {
            return this._last < this._max;
        }

        public Object next() {
            return new Integer(++this._last);
        }

        public void bindTable(PreparedStatement stmt, int index) throws SQLException {
            stmt.setString(index, this._table);
        }

        public void bindLast(PreparedStatement stmt, int index) throws SQLException {
            stmt.setInt(index, this._last);
        }

        public void bindMax(PreparedStatement stmt, int index) throws SQLException {
            stmt.setInt(index, this._max);
        }
    }

    private static interface HighLowSqlTypeHandler {
        public void init(ResultSet var1) throws SQLException;

        public boolean hasNext();

        public Object next();

        public void bindTable(PreparedStatement var1, int var2) throws SQLException;

        public void bindLast(PreparedStatement var1, int var2) throws SQLException;

        public void bindMax(PreparedStatement var1, int var2) throws SQLException;
    }
}

