/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cpa.persistence.sql.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.cpa.persistence.sql.keygen.AbstractKeyGenValueHandler;
import org.castor.cpa.persistence.sql.keygen.SqlTypeHandler;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private static Log _log = LogFactory.getFactory().getInstance(IdentityKeyGenerator.class);
    private final PersistenceFactory _factory;
    private SqlTypeHandler _sqlTypeHandler;
    private IdentityKeyGenValueHandler _type;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        this._factory = factory;
        this.supportsFactory(factory);
        this.supportsSqlType(sqlType);
        this.initSqlTypeHandler(sqlType);
        this.initType();
    }

    private void supportsFactory(PersistenceFactory factory) throws MappingException {
        String factoryName = factory.getFactoryName();
        String[] supportedFactoryNames = new String[]{"sybase", "sql-server", "hsql", "mysql", "informix", "sapdb", "db2", "derby", "postgresql", "pointbase"};
        boolean supported = false;
        for (int i = 0; i < supportedFactoryNames.length; ++i) {
            if (!factoryName.equals(supportedFactoryNames[i])) continue;
            supported = true;
        }
        if (!supported) {
            String msg = Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), factoryName);
            throw new MappingException(msg);
        }
    }

    private void initSqlTypeHandler(int sqlType) {
        this._sqlTypeHandler = sqlType == 4 ? new IntegerSqlTypeHandler() : (sqlType == -5 ? new LongSqlTypeHandler() : (sqlType == 1 || sqlType == 12 ? new StringSqlTypeHandler() : new BigDecimalSqlTypeHandler()));
    }

    private void initType() {
        String factoryName = this._factory.getFactoryName();
        this._type = factoryName.equals("hsql") ? new HsqlType() : (factoryName.equals("mysql") ? new MySqlType() : (factoryName.equals("informix") ? new InformixType() : (factoryName.equals("db2") ? new DB2Type() : (factoryName.equals("sapdb") ? new SapDbType() : (factoryName.equals("derby") ? new DerbyType() : (factoryName.equals("postgresql") ? new PostgresqlType() : new DefaultType()))))));
        this._type.setGenerator(this);
        this._type.setSqlTypeHandler(this._sqlTypeHandler);
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        try {
            return this._type.getValue(conn, tableName);
        }
        catch (Exception e) {
            _log.error((Object)"Problem generating new key", (Throwable)e);
            return null;
        }
    }

    public void supportsSqlType(int sqlType) throws MappingException {
        String factoryName = this._factory.getFactoryName();
        if (factoryName.equals("hsql") ? sqlType != 4 : (factoryName.equals("derby") ? sqlType != 2 : sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5)) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public byte getStyle() {
        return 1;
    }

    public boolean isInSameConnection() {
        return true;
    }

    public String patchSQL(String insert, String primKeyName) {
        return insert;
    }

    private class StringSqlTypeHandler
    implements SqlTypeHandler {
        private StringSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return rs.getString(1);
        }
    }

    private class BigDecimalSqlTypeHandler
    implements SqlTypeHandler {
        private BigDecimalSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return rs.getBigDecimal(1);
        }
    }

    private class LongSqlTypeHandler
    implements SqlTypeHandler {
        private LongSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return new Long(rs.getLong(1));
        }
    }

    private class IntegerSqlTypeHandler
    implements SqlTypeHandler {
        private IntegerSqlTypeHandler() {
        }

        public Object getValue(ResultSet rs) throws SQLException {
            return new Integer(rs.getInt(1));
        }
    }

    private class PostgresqlType
    extends IdentityKeyGenValueHandler {
        private PostgresqlType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT currval ('" + tableName + "_id_seq')", conn);
        }
    }

    private class DerbyType
    extends IdentityKeyGenValueHandler {
        private DerbyType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT IDENTITY_VAL_LOCAL() FROM " + tableName, conn);
        }
    }

    private class SapDbType
    extends IdentityKeyGenValueHandler {
        private SapDbType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT " + tableName + ".currval" + " FROM " + tableName, conn);
        }
    }

    private class MySqlType
    extends IdentityKeyGenValueHandler {
        private MySqlType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT LAST_INSERT_ID()", conn);
        }
    }

    private class InformixType
    extends IdentityKeyGenValueHandler {
        private InformixType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1", conn);
        }
    }

    private class HsqlType
    extends IdentityKeyGenValueHandler {
        private HsqlType() {
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            CallableStatement stmt = null;
            Object v = null;
            stmt = conn.prepareCall("{call IDENTITY()}");
            v = this.getValue(stmt);
            Object var8_5 = null;
            if (stmt == null) return v;
            try {
                stmt.close();
                return v;
            }
            catch (SQLException ex) {
                _log.warn((Object)"Problem closing JDBCstatement", (Throwable)ex);
            }
            return v;
            {
                catch (SQLException e) {
                    String msg = Messages.format("persist.keyGenSQL", this.getClass().getName(), e.toString());
                    throw new PersistenceException(msg);
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (stmt == null) throw throwable;
                try {
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    _log.warn((Object)"Problem closing JDBCstatement", (Throwable)ex);
                }
                throw throwable;
            }
        }
    }

    private class DB2Type
    extends IdentityKeyGenValueHandler {
        private DB2Type() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT IDENTITY_VAL_LOCAL() FROM sysibm.sysdummy1", conn);
        }
    }

    private class DefaultType
    extends IdentityKeyGenValueHandler {
        private DefaultType() {
        }

        protected Object getValue(Connection conn, String tableName) throws PersistenceException {
            return this.getValue("SELECT @@identity", conn);
        }
    }

    private abstract class IdentityKeyGenValueHandler
    extends AbstractKeyGenValueHandler {
        private IdentityKeyGenValueHandler() {
        }

        protected abstract Object getValue(Connection var1, String var2) throws PersistenceException;
    }
}

