/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.keygenerator;

import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.Param;

public final class HighLowKeyGenerator
extends KeyGenerator {
    public static final String ALGORITHM_NAME = "HIGH-LOW";
    private static final String PARAM_TABLE_NAME = "table";
    private static final String PARAM_KEY_COLUMN = "key-column";
    private static final String PARAM_VALUE_COLUMN = "value-column";
    private static final String PARAM_GRAB_SIZE = "grab-size";
    private static final String PARAM_SAME_CONNECTION = "same-connection";
    private static final String PARAM_GLOBAL_KEYS = "global";
    private String _tableName;
    private String _keyColumn;
    private String _valueColumn;
    private int _grabSize;
    private boolean _isSameConnection = false;
    private boolean _isGlobal = false;

    public HighLowKeyGenerator(KeyGeneratorDef definition) throws GeneratorException {
        super(ALGORITHM_NAME, definition.getAlias());
        Param[] params = definition.getParam();
        for (int i = 0; i < params.length; ++i) {
            String name = params[i].getName();
            String value = params[i].getValue();
            if (name == null) continue;
            if (PARAM_TABLE_NAME.equalsIgnoreCase(value)) {
                this._tableName = value;
                continue;
            }
            if (PARAM_KEY_COLUMN.equalsIgnoreCase(value)) {
                this._keyColumn = value;
                continue;
            }
            if (PARAM_VALUE_COLUMN.equalsIgnoreCase(value)) {
                this._valueColumn = value;
                continue;
            }
            if (PARAM_GRAB_SIZE.equalsIgnoreCase(value)) {
                try {
                    this._grabSize = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new GeneratorException("Can't parse integer" + value, nfe);
                }
            }
            if (PARAM_SAME_CONNECTION.equalsIgnoreCase(name)) {
                this._isSameConnection = Boolean.valueOf(value);
                continue;
            }
            if (!PARAM_GLOBAL_KEYS.equals(name.toLowerCase())) continue;
            this._isGlobal = Boolean.valueOf(value);
        }
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getKeyColumn() {
        return this._keyColumn;
    }

    public String getValueColumn() {
        return this._valueColumn;
    }

    public int getGrabSize() {
        return this._grabSize;
    }

    public boolean isSameConnection() {
        return this._isSameConnection;
    }

    public boolean isGlobal() {
        return this._isGlobal;
    }

    public void toCreateDDL(DDLWriter writer) {
    }

    public void toDropDDL(DDLWriter writer) {
    }
}

