/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.conf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.Mapping;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Serializable {
    private String _name;
    private String _engine = "generic";
    private DatabaseChoice _databaseChoice;
    private List<Mapping> _mappingList;

    public Database() {
        this.setEngine("generic");
        this._mappingList = new ArrayList<Mapping>();
    }

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(index, vMapping);
    }

    public Enumeration<? extends Mapping> enumerateMapping() {
        return Collections.enumeration(this._mappingList);
    }

    public DatabaseChoice getDatabaseChoice() {
        return this._databaseChoice;
    }

    public String getEngine() {
        return this._engine;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        return this._mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this._mappingList.toArray(array);
    }

    public int getMappingCount() {
        return this._mappingList.size();
    }

    public String getName() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Mapping> iterateMapping() {
        return this._mappingList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, handler);
    }

    public void removeAllMapping() {
        this._mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this._mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this._mappingList.remove(index);
        return obj;
    }

    public void setDatabaseChoice(DatabaseChoice databaseChoice) {
        this._databaseChoice = databaseChoice;
    }

    public void setEngine(String engine) {
        this._engine = engine;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        this._mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this._mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this._mappingList.add(vMappingArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public static Database unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Database)Unmarshaller.unmarshal(Database.class, reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

