/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.conf;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdoConf
implements Serializable {
    private String _name = "jdo-conf";
    private List<Database> _databaseList;
    private TransactionDemarcation _transactionDemarcation;

    public JdoConf() {
        this.setName("jdo-conf");
        this._databaseList = new ArrayList<Database>();
    }

    public void addDatabase(Database vDatabase) throws IndexOutOfBoundsException {
        this._databaseList.add(vDatabase);
    }

    public void addDatabase(int index, Database vDatabase) throws IndexOutOfBoundsException {
        this._databaseList.add(index, vDatabase);
    }

    public Enumeration<? extends Database> enumerateDatabase() {
        return Collections.enumeration(this._databaseList);
    }

    public Database getDatabase(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._databaseList.size()) {
            throw new IndexOutOfBoundsException("getDatabase: Index value '" + index + "' not in range [0.." + (this._databaseList.size() - 1) + "]");
        }
        return this._databaseList.get(index);
    }

    public Database[] getDatabase() {
        Database[] array = new Database[]{};
        return this._databaseList.toArray(array);
    }

    public int getDatabaseCount() {
        return this._databaseList.size();
    }

    public String getName() {
        return this._name;
    }

    public TransactionDemarcation getTransactionDemarcation() {
        return this._transactionDemarcation;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<? extends Database> iterateDatabase() {
        return this._databaseList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, handler);
    }

    public void removeAllDatabase() {
        this._databaseList.clear();
    }

    public boolean removeDatabase(Database vDatabase) {
        boolean removed = this._databaseList.remove(vDatabase);
        return removed;
    }

    public Database removeDatabaseAt(int index) {
        Database obj = this._databaseList.remove(index);
        return obj;
    }

    public void setDatabase(int index, Database vDatabase) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._databaseList.size()) {
            throw new IndexOutOfBoundsException("setDatabase: Index value '" + index + "' not in range [0.." + (this._databaseList.size() - 1) + "]");
        }
        this._databaseList.set(index, vDatabase);
    }

    public void setDatabase(Database[] vDatabaseArray) {
        this._databaseList.clear();
        for (int i = 0; i < vDatabaseArray.length; ++i) {
            this._databaseList.add(vDatabaseArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTransactionDemarcation(TransactionDemarcation transactionDemarcation) {
        this._transactionDemarcation = transactionDemarcation;
    }

    public static JdoConf unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (JdoConf)Unmarshaller.unmarshal(JdoConf.class, reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate(this);
    }
}

