/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Param;
import org.castor.jdo.drivers.ConnectionProxyFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;

public final class DataSourceConnectionFactory
extends AbstractConnectionFactory {
    private static final Log LOG = LogFactory.getLog(DataSourceConnectionFactory.class);
    private DataSource _dataSource = null;

    public static DataSource loadDataSource(Database database, ClassLoader loader) throws MappingException {
        DataSource dataSource;
        DatabaseChoice dbChoice = database.getDatabaseChoice();
        String className = dbChoice.getDataSource().getClassName();
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            Class<?> dsClass = Class.forName(className, true, classLoader);
            dataSource = (DataSource)dsClass.newInstance();
        }
        catch (Exception e) {
            String msg = Messages.format("jdo.engine.classNotInstantiable", className);
            LOG.error((Object)msg, (Throwable)e);
            throw new MappingException(msg, e);
        }
        Param[] parameters = database.getDatabaseChoice().getDataSource().getParam();
        DataSourceConnectionFactory.setParameters(dataSource, parameters);
        return dataSource;
    }

    public static void setParameters(DataSource dataSource, Param[] params) throws MappingException {
        Method[] methods = dataSource.getClass().getMethods();
        for (int j = 0; j < params.length; ++j) {
            String name = DataSourceConnectionFactory.buildMethodName(params[j].getName());
            String value = params[j].getValue();
            boolean success = false;
            Exception cause = null;
            try {
                for (int i = 0; !success && i < methods.length; ++i) {
                    Method method = methods[i];
                    Class<?>[] types = method.getParameterTypes();
                    if (!method.getName().equals(name) || types.length != 1) continue;
                    if (types[0] == String.class) {
                        method.invoke((Object)dataSource, value);
                        success = true;
                        continue;
                    }
                    if (types[0] == Integer.TYPE) {
                        method.invoke((Object)dataSource, new Integer(value));
                        success = true;
                        continue;
                    }
                    if (types[0] == Long.TYPE) {
                        method.invoke((Object)dataSource, new Long(value));
                        success = true;
                        continue;
                    }
                    if (types[0] != Boolean.TYPE) continue;
                    method.invoke((Object)dataSource, new Boolean(value));
                    success = true;
                }
            }
            catch (Exception e) {
                cause = e;
            }
            if (success && cause == null) continue;
            String msg = Messages.format("jdo.engine.datasourceParaFail", params[j].getName(), value);
            LOG.error((Object)msg, (Throwable)cause);
            throw new MappingException(msg, cause);
        }
    }

    public static String buildMethodName(String name) {
        StringBuffer sb = new StringBuffer("set");
        boolean first = true;
        for (int i = 0; i < name.length(); ++i) {
            char chr = name.charAt(i);
            if (first && Character.isLowerCase(chr)) {
                sb.append(Character.toUpperCase(chr));
                first = false;
                continue;
            }
            if (Character.isLetter(chr)) {
                sb.append(chr);
                first = false;
                continue;
            }
            if (chr != '-') continue;
            first = true;
        }
        return sb.toString();
    }

    public DataSourceConnectionFactory(String name, String engine, DataSource datasource, Mapping mapping, TransactionManager txManager) throws MappingException {
        super(name, engine, mapping, txManager);
        this._dataSource = datasource;
    }

    public DataSourceConnectionFactory(JdoConf jdoConf, int index, Mapping mapping) {
        super(jdoConf, index, mapping);
    }

    public void initializeFactory() throws MappingException {
        this._dataSource = DataSourceConnectionFactory.loadDataSource(this.getDatabase(), this.getMapping().getClassLoader());
        if (LOG.isDebugEnabled()) {
            DatabaseChoice dbc = this.getDatabase().getDatabaseChoice();
            LOG.debug((Object)("Using DataSource: " + dbc.getDataSource().getClassName()));
        }
    }

    public Connection createConnection() throws SQLException {
        return ConnectionProxyFactory.newConnectionProxy(this._dataSource.getConnection(), this.getClass().getName());
    }
}

