/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.Messages;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Param;
import org.castor.jdo.drivers.ConnectionProxyFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;

public final class DriverConnectionFactory
extends AbstractConnectionFactory {
    private static final Log LOG = LogFactory.getLog(DriverConnectionFactory.class);
    private String _url = null;
    private Properties _props;

    public DriverConnectionFactory(JdoConf jdoConf, int index, Mapping mapping) {
        super(jdoConf, index, mapping);
    }

    public void initializeFactory() throws MappingException {
        DatabaseChoice dbChoice = this.getDatabase().getDatabaseChoice();
        String driverName = dbChoice.getDriver().getClassName();
        if (driverName != null) {
            try {
                Class.forName(driverName).newInstance();
            }
            catch (InstantiationException e) {
                String msg = Messages.format("jdo.engine.classNotInstantiable", driverName);
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
            catch (IllegalAccessException e) {
                String msg = Messages.format("jdo.engine.classNotAccessable", driverName, "constructor");
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
            catch (ClassNotFoundException e) {
                String msg = "Can not load class " + driverName;
                LOG.error((Object)msg, (Throwable)e);
                throw new MappingException(msg, (Exception)e);
            }
        }
        try {
            Driver driver = dbChoice.getDriver();
            if (DriverManager.getDriver(driver.getUrl()) == null) {
                String msg = Messages.format("jdo.missingDriver", driver.getUrl());
                LOG.error((Object)msg);
                throw new MappingException(msg);
            }
        }
        catch (SQLException ex) {
            throw new MappingException(ex);
        }
        this._url = dbChoice.getDriver().getUrl();
        this._props = new Properties();
        Enumeration<? extends Param> params = dbChoice.getDriver().enumerateParam();
        while (params.hasMoreElements()) {
            Param param = params.nextElement();
            this._props.put(param.getName(), param.getValue());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using driver: " + driverName));
        }
    }

    public Connection createConnection() throws SQLException {
        return ConnectionProxyFactory.newConnectionProxy(DriverManager.getConnection(this._url, this._props), this.getClass().getName());
    }
}

