/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.jpa.info;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.castor.core.annotationprocessing.AnnotationProcessingService;
import org.castor.jdo.jpa.info.ClassInfo;
import org.castor.jdo.jpa.info.FieldInfo;
import org.castor.jdo.jpa.info.JPAClassAnnotationProcessingService;
import org.castor.jdo.jpa.info.JPAFieldAnnotationProcessingService;
import org.castor.jdo.jpa.natures.JPAClassNature;
import org.castor.jdo.jpa.natures.JPAFieldNature;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfoBuilder {
    private AnnotationProcessingService _classAnnotationProcessingService = new JPAClassAnnotationProcessingService();
    private AnnotationProcessingService _fieldAnnotationProcessingService = new JPAFieldAnnotationProcessingService();

    public final AnnotationProcessingService getClassAnnotationProcessingService() {
        return this._classAnnotationProcessingService;
    }

    public final void setClassAnnotationProcessingService(AnnotationProcessingService annotationProcessingService) {
        this._classAnnotationProcessingService = annotationProcessingService;
    }

    public final AnnotationProcessingService getFieldAnnotationProcessingService() {
        return this._fieldAnnotationProcessingService;
    }

    public final void setFieldAnnotationProcessingService(AnnotationProcessingService annotationProcessingService) {
        this._fieldAnnotationProcessingService = annotationProcessingService;
    }

    public final ClassInfo buildClassInfo(Class<?> type) throws MappingException {
        if (type == null) {
            throw new IllegalArgumentException("Argument type must not be null");
        }
        if (!this.isDescribeable(type)) {
            return null;
        }
        ClassInfo classInfo = new ClassInfo(type);
        classInfo.addNature(JPAClassNature.class.getName());
        JPAClassNature jpaClassNature = new JPAClassNature(classInfo);
        this._classAnnotationProcessingService.processAnnotations(jpaClassNature, type.getAnnotations());
        for (Field field : type.getDeclaredFields()) {
            if (field.getAnnotations().length == 0) continue;
            if (this.isDescribeable(type, field)) {
                this.buildFieldInfo(classInfo, field);
                continue;
            }
            throw new MappingException("Invalid field annotated, field is not describeable!");
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!this.isGetter((Method)accessibleObject) || accessibleObject.getAnnotations().length == 0) continue;
            if (this.isDescribeable(type, (Method)accessibleObject)) {
                this.buildFieldInfo(classInfo, (Method)accessibleObject);
                continue;
            }
            throw new MappingException("Invalid method annotated, method is not describeable!");
        }
        return classInfo;
    }

    private void buildFieldInfo(ClassInfo classInfo, Method method) throws MappingException {
        FieldHandlerImpl fieldHandler;
        if (classInfo == null) {
            throw new IllegalArgumentException("Argument classInfo must not be null.");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument method must not be null.");
        }
        String fieldName = this.getFieldNameFromGetterMethod(method);
        if (fieldName == null) {
            throw new IllegalArgumentException("Can not resolve Fieldname from method name.");
        }
        FieldInfo fieldInfo = classInfo.getFieldInfoByName(fieldName);
        if (fieldInfo == null && (fieldInfo = classInfo.getKeyFieldInfoByName(fieldName)) != null) {
            throw new MappingException("Can not annotate field and method!");
        }
        Class<?> fieldType = method.getReturnType();
        TypeInfo typeInfo = new TypeInfo(fieldType);
        try {
            fieldHandler = new FieldHandlerImpl(fieldName, null, null, method, this.getSetterMethodFromGetter(method), typeInfo);
        }
        catch (SecurityException e) {
            throw new MappingException("Setter method for field " + fieldName + " is not accessible!");
        }
        catch (NoSuchMethodException e) {
            throw new MappingException("Setter method for field " + fieldName + " does not exist!");
        }
        fieldInfo = new FieldInfo(classInfo, fieldType, fieldName, fieldHandler);
        fieldInfo.addNature(JPAFieldNature.class.getName());
        JPAFieldNature jpaFieldNature = new JPAFieldNature(fieldInfo);
        this._fieldAnnotationProcessingService.processAnnotations(jpaFieldNature, method.getAnnotations());
        classInfo.addFieldInfo(fieldInfo);
    }

    private void buildFieldInfo(ClassInfo classInfo, Field field) throws MappingException {
        if (classInfo == null) {
            throw new IllegalArgumentException("Argument classInfo must not be null.");
        }
        if (field == null) {
            throw new IllegalArgumentException("Argument field must not be null.");
        }
        Class<?> fieldType = field.getType();
        TypeInfo typeInfo = new TypeInfo(fieldType);
        FieldHandlerImpl fieldHandler = new FieldHandlerImpl(field, typeInfo);
        FieldInfo fieldInfo = new FieldInfo(classInfo, fieldType, field.getName(), fieldHandler);
        fieldInfo.addNature(JPAFieldNature.class.getName());
        JPAFieldNature jpaFieldNature = new JPAFieldNature(fieldInfo);
        this._fieldAnnotationProcessingService.processAnnotations(jpaFieldNature, field.getAnnotations());
        classInfo.addFieldInfo(fieldInfo);
    }

    private boolean isGetter(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private String getFieldNameFromGetterMethod(Method method) {
        if (!this.isGetter(method)) {
            throw new IllegalArgumentException("Method is not a getter method!");
        }
        if (method.getName().startsWith("get")) {
            String nameRest = method.getName().substring(4);
            return Character.toLowerCase(method.getName().charAt(3)) + nameRest;
        }
        if (method.getName().startsWith("is")) {
            String nameRest = method.getName().substring(3);
            return Character.toLowerCase(method.getName().charAt(2)) + nameRest;
        }
        throw new IllegalArgumentException("Method name does not start with 'get' or 'is'!");
    }

    private Method getSetterMethodFromGetter(Method getter) throws SecurityException, NoSuchMethodException {
        String setterName;
        if (!this.isGetter(getter)) {
            throw new IllegalArgumentException("Method is not a getter method!");
        }
        if (getter.getName().startsWith("get")) {
            String name = getter.getName().substring(1);
            setterName = "s" + name;
        } else if (getter.getName().startsWith("is")) {
            String name = getter.getName().substring(2);
            setterName = "set" + name;
        } else {
            throw new IllegalArgumentException("Method name does not start with 'get' or 'is'!");
        }
        return getter.getDeclaringClass().getDeclaredMethod(setterName, getter.getReturnType());
    }

    private boolean isDescribeable(Class<?> type) {
        return !Object.class.equals(type) && !Void.class.equals(type) && !Class.class.equals(type);
    }

    private boolean isDescribeable(Class<?> type, Field field) {
        boolean isDescribeable = true;
        Class<?> declaringClass = field.getDeclaringClass();
        if (declaringClass != null && !type.equals(declaringClass) && !declaringClass.isInterface()) {
            isDescribeable = false;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            isDescribeable &= false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            isDescribeable &= false;
        }
        if (field.isSynthetic()) {
            isDescribeable &= false;
        }
        return isDescribeable;
    }

    private boolean isDescribeable(Class<?> type, Method method) {
        boolean isDescribeable = true;
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass != null && !type.equals(declaringClass) && !declaringClass.isInterface()) {
            isDescribeable = false;
        }
        if (method.isSynthetic()) {
            isDescribeable &= false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            isDescribeable &= false;
        }
        if (Modifier.isTransient(method.getModifiers())) {
            isDescribeable &= false;
        }
        return isDescribeable;
    }
}

