/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.jpa.info;

import org.castor.core.nature.PropertyHolder;
import org.castor.jdo.jpa.info.ClassInfo;
import org.castor.jdo.jpa.info.FieldInfo;
import org.castor.jdo.jpa.natures.JPAClassNature;
import org.castor.jdo.jpa.natures.JPAFieldNature;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.jdo.engine.nature.FieldDescriptorJDONature;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.xml.util.ClassDescriptorResolutionCommand;

public final class InfoToDescriptorConverter {
    private InfoToDescriptorConverter() {
    }

    public static ClassDescriptorImpl convert(ClassInfo classInfo, ClassDescriptorResolutionCommand command) throws MappingException {
        if (!classInfo.hasNature(JPAClassNature.class.getName())) {
            throw new IllegalArgumentException("ClassInfo must have JPAClassNature on it!");
        }
        if (!Types.isConstructable(classInfo.getDescribedClass(), true)) {
            throw new MappingException("mapping.classNotConstructable", classInfo.getDescribedClass().getName());
        }
        JPAClassNature nature = new JPAClassNature(classInfo);
        ClassDescriptorImpl descriptor = new ClassDescriptorImpl();
        descriptor.addNature(ClassDescriptorJDONature.class.getName());
        ClassDescriptorJDONature jdoNature = new ClassDescriptorJDONature((PropertyHolder)((Object)descriptor));
        descriptor.setJavaClass(classInfo.getDescribedClass());
        descriptor.setExtends(null);
        Class<?> extendedClass = classInfo.getExtendedClass();
        if (extendedClass != null && extendedClass != Object.class) {
            ClassDescriptor extendedClassDescriptor = command.resolve(extendedClass);
            if (extendedClassDescriptor == null) {
                throw new MappingException("mapping.extendsMissing", classInfo.getDescribedClass(), extendedClass);
            }
            descriptor.setExtends(extendedClassDescriptor);
            if (extendedClassDescriptor.hasNature(ClassDescriptorJDONature.class.getName())) {
                new ClassDescriptorJDONature((PropertyHolder)((Object)extendedClassDescriptor)).addExtended(descriptor);
            }
        }
        descriptor.setDepends(null);
        descriptor.setMapping(null);
        jdoNature.setTableName(null);
        jdoNature.setAccessMode(null);
        jdoNature.setKeyGeneratorDescriptor(null);
        FieldDescriptor[] fields = new FieldDescriptor[classInfo.getFieldCount()];
        int i = 0;
        for (FieldInfo fieldInfo : classInfo.getFieldInfos()) {
            fields[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo);
            ++i;
        }
        descriptor.setFields(fields);
        FieldDescriptor[] keys = new FieldDescriptor[classInfo.getKeyFieldCount()];
        i = 0;
        for (FieldInfo fieldInfo : classInfo.getKeyFieldInfos()) {
            keys[i] = InfoToDescriptorConverter.convert(descriptor, fieldInfo);
            ++i;
        }
        descriptor.setIdentities(keys);
        return descriptor;
    }

    private static FieldDescriptorImpl convert(ClassDescriptor parent, FieldInfo fieldInfo) throws MappingException {
        if (!fieldInfo.hasNature(JPAFieldNature.class.getName())) {
            throw new IllegalArgumentException("FieldInfo must have JPAFieldNature on it!");
        }
        JPAFieldNature jpaNature = new JPAFieldNature(fieldInfo);
        String name = fieldInfo.getFieldName();
        TypeInfo typeInfo = new TypeInfo(fieldInfo.getFieldType());
        FieldHandlerImpl handler = fieldInfo.getFieldHandler();
        boolean isTransient = false;
        FieldDescriptorImpl descriptor = new FieldDescriptorImpl(name, typeInfo, handler, isTransient);
        descriptor.setContainingClassDescriptor(parent);
        descriptor.setFieldType(fieldInfo.getFieldType());
        descriptor.setIdentity(false);
        descriptor.setClassDescriptor(null);
        descriptor.setImmutable(false);
        descriptor.setMultivalued(false);
        descriptor.setRequired(false);
        descriptor.addNature(FieldDescriptorJDONature.class.getName());
        FieldDescriptorJDONature jdoNature = new FieldDescriptorJDONature((PropertyHolder)((Object)descriptor));
        jdoNature.setManyKey(null);
        jdoNature.setManyTable(null);
        jdoNature.setSQLType(null);
        jdoNature.setSQLName(null);
        jdoNature.setTypeConvertor(null);
        jdoNature.setDirtyCheck(true);
        jdoNature.setReadOnly(false);
        return descriptor;
    }
}

