/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.conf.DataSource;
import org.castor.jdo.conf.Database;
import org.castor.jdo.conf.DatabaseChoice;
import org.castor.jdo.conf.Driver;
import org.castor.jdo.conf.JdoConf;
import org.castor.jdo.conf.Jndi;
import org.castor.jdo.conf.Mapping;
import org.castor.jdo.conf.Param;
import org.castor.jdo.conf.TransactionDemarcation;
import org.castor.jdo.conf.TransactionManager;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class JDOConfFactory {
    private static final String NOTE_096 = "NOTE: JDO configuration syntax has changed with castor 0.9.6, please see http://castor.codehaus.org/release-notes.html for details";
    private static final Log LOG = LogFactory.getLog(JDOConfFactory.class);

    public static JdoConf createJdoConf(InputSource source, EntityResolver resolver, ClassLoader loader) throws MappingException {
        JdoConf jdoConf = null;
        Unmarshaller unmarshaller = new Unmarshaller(JdoConf.class);
        try {
            unmarshaller.setEntityResolver(new DTDResolver(resolver));
            jdoConf = (JdoConf)unmarshaller.unmarshal(source);
        }
        catch (MarshalException e) {
            LOG.info((Object)NOTE_096);
            throw new MappingException(e);
        }
        catch (ValidationException e) {
            throw new MappingException(e);
        }
        return jdoConf;
    }

    public static JdoConf createJdoConf(Database database) {
        return JDOConfFactory.createJdoConf(new Database[]{database}, JDOConfFactory.createLocalTransactionDemarcation());
    }

    public static JdoConf createJdoConf(Database[] databases) {
        return JDOConfFactory.createJdoConf(databases, JDOConfFactory.createLocalTransactionDemarcation());
    }

    public static JdoConf createJdoConf(Database database, TransactionDemarcation tx) {
        return JDOConfFactory.createJdoConf(new Database[]{database}, tx);
    }

    public static JdoConf createJdoConf(Database[] databases, TransactionDemarcation tx) {
        JdoConf jdoConf = new JdoConf();
        jdoConf.setDatabase(databases);
        jdoConf.setTransactionDemarcation(tx);
        return jdoConf;
    }

    public static Database createDatabase(String name, String engine, DataSource ds, Mapping mapping) {
        return JDOConfFactory.createDatabase(name, engine, ds, new Mapping[]{mapping});
    }

    public static Database createDatabase(String name, String engine, DataSource ds, Mapping[] mappings) {
        DatabaseChoice dbChoice = new DatabaseChoice();
        dbChoice.setDataSource(ds);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoice);
        dbConf.setMapping(mappings);
        return dbConf;
    }

    public static Database createDatabase(String name, String engine, DataSource ds, String mapping) {
        return JDOConfFactory.createDatabase(name, engine, ds, new String[]{mapping});
    }

    public static Database createDatabase(String name, String engine, DataSource ds, String[] mappings) {
        DatabaseChoice dbChoice = new DatabaseChoice();
        dbChoice.setDataSource(ds);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoice);
        dbConf.setMapping(JDOConfFactory.createMappings(mappings));
        return dbConf;
    }

    public static Database createDatabase(String name, String engine, Driver driver, Mapping mapping) {
        return JDOConfFactory.createDatabase(name, engine, driver, new Mapping[]{mapping});
    }

    public static Database createDatabase(String name, String engine, Driver driver, Mapping[] mappings) {
        DatabaseChoice dbChoise = new DatabaseChoice();
        dbChoise.setDriver(driver);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoise);
        dbConf.setMapping(mappings);
        return dbConf;
    }

    public static Database createDatabase(String name, String engine, Driver driver, String mapping) {
        return JDOConfFactory.createDatabase(name, engine, driver, new String[]{mapping});
    }

    public static Database createDatabase(String name, String engine, Driver driver, String[] mappings) {
        DatabaseChoice dbChoise = new DatabaseChoice();
        dbChoise.setDriver(driver);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoise);
        dbConf.setMapping(JDOConfFactory.createMappings(mappings));
        return dbConf;
    }

    public static Database createDatabase(String name, String engine, Jndi jndi, String mapping) {
        return JDOConfFactory.createDatabase(name, engine, jndi, new String[]{mapping});
    }

    public static Database createDatabase(String name, String engine, Jndi jndi, String[] mappings) {
        DatabaseChoice dbChoise = new DatabaseChoice();
        dbChoise.setJndi(jndi);
        Database dbConf = JDOConfFactory.createDatabase(name, engine);
        dbConf.setDatabaseChoice(dbChoise);
        dbConf.setMapping(JDOConfFactory.createMappings(mappings));
        return dbConf;
    }

    private static Database createDatabase(String name, String engine) {
        Database dbConf = new Database();
        dbConf.setName(name);
        dbConf.setEngine(engine);
        return dbConf;
    }

    public static Driver createDriver(String driver, String connect, String user, String password) {
        Driver driverConf = new Driver();
        driverConf.setClassName(driver);
        driverConf.setUrl(connect);
        driverConf.addParam(JDOConfFactory.createParam("user", user));
        driverConf.addParam(JDOConfFactory.createParam("password", password));
        return driverConf;
    }

    public static DataSource createDataSource(String datasource, Properties props) {
        DataSource dsConf = new DataSource();
        dsConf.setClassName(datasource);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            dsConf.addParam(JDOConfFactory.createParam(key, value));
        }
        return dsConf;
    }

    public static Jndi createJNDI(String name) {
        Jndi jndi = new Jndi();
        jndi.setName(name);
        return jndi;
    }

    public static Mapping createMapping(String mapping) {
        Mapping mapConf = new Mapping();
        mapConf.setHref(mapping);
        return mapConf;
    }

    private static Mapping[] createMappings(String[] mappings) {
        Mapping[] mapConfs = new Mapping[mappings.length];
        for (int i = 0; i < mappings.length; ++i) {
            mapConfs[i] = new Mapping();
            mapConfs[i].setHref(mappings[i]);
        }
        return mapConfs;
    }

    public static TransactionDemarcation createTransactionDemarcation() {
        return JDOConfFactory.createLocalTransactionDemarcation();
    }

    public static TransactionDemarcation createLocalTransactionDemarcation() {
        TransactionDemarcation trans = new TransactionDemarcation();
        trans.setMode("local");
        return trans;
    }

    public static TransactionDemarcation createGlobalTransactionDemarcation(String name, Properties props) {
        TransactionManager manager = new TransactionManager();
        manager.setName(name);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            manager.addParam(JDOConfFactory.createParam(key, value));
        }
        TransactionDemarcation trans = new TransactionDemarcation();
        trans.setMode("global");
        trans.setTransactionManager(manager);
        return trans;
    }

    private static Param createParam(String name, String value) {
        Param param = new Param();
        param.setName(name);
        param.setValue(value);
        return param;
    }

    private JDOConfFactory() {
    }
}

