/*
 * Decompiled with CFR 0.152.
 */
package org.castor.mapping;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.CoreProperties;
import org.castor.core.util.Messages;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingLoaderRegistry;
import org.castor.mapping.MappingSource;
import org.castor.mapping.MappingUnmarshallIDResolver;
import org.castor.mapping.MappingUnmarshallListener;
import org.castor.xml.AbstractInternalContext;
import org.castor.xml.InternalContext;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.mapping.loader.AbstractMappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.Include;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.ClassDescriptorResolverFactory;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.util.resolvers.CastorXMLStrategy;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MappingUnmarshaller {
    private static final Log LOG = LogFactory.getLog(MappingUnmarshaller.class);
    private final MappingLoaderRegistry _registry = new MappingLoaderRegistry(new CoreProperties());
    private final MappingUnmarshallIDResolver _idResolver = new MappingUnmarshallIDResolver();
    private boolean _allowRedefinitions = false;
    private InternalContext _internalContext;

    public MappingUnmarshaller() {
        AbstractInternalContext internalContext = new AbstractInternalContext(){};
        internalContext.setClassLoader(this.getClass().getClassLoader());
        XMLClassDescriptorResolver cdr = (XMLClassDescriptorResolver)ClassDescriptorResolverFactory.createClassDescriptorResolver(BindingType.XML);
        cdr.setInternalContext(internalContext);
        internalContext.setXMLClassDescriptorResolver(cdr);
        Introspector introspector = new Introspector();
        introspector.setInternalContext(internalContext);
        internalContext.setIntrospector(introspector);
        cdr.setIntrospector(introspector);
        CastorXMLStrategy resolverStrategy = new CastorXMLStrategy();
        internalContext.setResolverStrategy(resolverStrategy);
        cdr.setResolverStrategy(resolverStrategy);
        this._internalContext = internalContext;
    }

    public void setAllowRedefinitions(boolean allow) {
        this._allowRedefinitions = allow;
    }

    public MappingLoader getMappingLoader(Mapping mapping, BindingType bindingType) throws MappingException {
        return this.getMappingLoader(mapping, bindingType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingLoader getMappingLoader(Mapping mapping, BindingType bindingType, Object param) throws MappingException {
        MappingUnmarshaller mappingUnmarshaller = this;
        synchronized (mappingUnmarshaller) {
            for (MappingSource source : mapping.getMappingSources()) {
                this.loadMappingInternal(mapping, source.getResolver(), source.getSource());
            }
            AbstractMappingLoader loader = (AbstractMappingLoader)this._registry.getMappingLoader("CastorXmlMapping", bindingType);
            loader.setClassLoader(mapping.getClassLoader());
            loader.setAllowRedefinitions(this._allowRedefinitions);
            loader.setInternalContext(this._internalContext);
            loader.loadMapping(mapping.getRoot(), param);
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappingOnly(Mapping mapping) throws MappingException {
        MappingUnmarshaller mappingUnmarshaller = this;
        synchronized (mappingUnmarshaller) {
            for (MappingSource source : mapping.getMappingSources()) {
                this.loadMappingInternal(mapping, source.getResolver(), source.getSource());
            }
        }
    }

    protected void loadMappingInternal(Mapping mapping, DTDResolver resolver, String url) throws IOException, MappingException {
        try {
            InputSource source = resolver.resolveEntity(null, url);
            if (source == null) {
                source = new InputSource(url);
            }
            if (source.getSystemId() == null) {
                source.setSystemId(url);
            }
            LOG.info((Object)Messages.format("mapping.loadingFrom", url));
            this.loadMappingInternal(mapping, resolver, source);
        }
        catch (SAXException ex) {
            throw new MappingException(ex);
        }
    }

    private void loadMappingInternal(Mapping mapping, DTDResolver resolver, InputSource source) throws MappingException {
        this._registry.clear();
        Object id = source.getSystemId();
        if (id == null) {
            id = source.getByteStream();
        }
        if (id != null) {
            if (mapping.processed(id)) {
                return;
            }
            mapping.markAsProcessed(id);
        }
        MappingRoot root = mapping.getRoot();
        this._idResolver.setMapping(root);
        try {
            Unmarshaller unm = new Unmarshaller(MappingRoot.class);
            unm.setValidation(false);
            unm.setEntityResolver(resolver);
            unm.setClassLoader(Mapping.class.getClassLoader());
            unm.setIDResolver(this._idResolver);
            unm.setUnmarshalListener(new MappingUnmarshallListener(this, mapping, resolver));
            MappingRoot loaded = (MappingRoot)unm.unmarshal(source);
            Enumeration includes = loaded.enumerateInclude();
            while (includes.hasMoreElements()) {
                Include include = (Include)includes.nextElement();
                if (mapping.processed(include.getHref())) continue;
                try {
                    this.loadMappingInternal(mapping, resolver, include.getHref());
                }
                catch (Exception ex) {
                    throw new MappingException(ex);
                }
            }
            Enumeration enumeration = loaded.enumerateClassMapping();
            while (enumeration.hasMoreElements()) {
                root.addClassMapping((ClassMapping)enumeration.nextElement());
            }
            enumeration = loaded.enumerateKeyGeneratorDef();
            while (enumeration.hasMoreElements()) {
                root.addKeyGeneratorDef((KeyGeneratorDef)enumeration.nextElement());
            }
            root.setFieldHandlerDef(loaded.getFieldHandlerDef());
        }
        catch (Exception ex) {
            throw new MappingException(ex);
        }
    }
}

