/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.proxy;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.proxy.LazyCGLIB;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.spi.Identity;

public final class SingleProxy
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -1498354553937679053L;
    private static final Log LOG = LogFactory.getLog(SingleProxy.class);
    private TransactionContext _tx;
    private ClassMolder _classMolder;
    private Class _clazz;
    private Identity _identity;
    private Object _object;
    private AccessMode _accessMode;
    private boolean _hasMaterialized = false;

    private SingleProxy(TransactionContext tx, ClassMolder classMolder, Class clazz, Identity identity, Object object, AccessMode accessMode) {
        this._tx = tx;
        this._classMolder = classMolder;
        this._clazz = clazz;
        this._identity = identity;
        this._object = object;
        this._accessMode = accessMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created new SingleProxy for an instance of '" + classMolder.getName() + "' with id '" + identity + "'"));
        }
    }

    public static synchronized Object getProxy(TransactionContext tx, ClassMolder classMolder, Identity identity, Object object, AccessMode accessMode) throws ObjectNotFoundException {
        try {
            Class<?> clazz = Class.forName(classMolder.getName());
            SingleProxy sp = new SingleProxy(tx, classMolder, clazz, identity, object, accessMode);
            return Enhancer.create(clazz, (Class[])new Class[]{LazyCGLIB.class}, (Callback)sp);
        }
        catch (Throwable ex) {
            if (LOG.isErrorEnabled()) {
                String msg = "error on enhance class";
                if (classMolder != null) {
                    msg = msg + " " + classMolder.getName();
                }
                LOG.error((Object)msg, ex);
            }
            throw new ObjectNotFoundException("lazy loading error - " + ex.getMessage(), ex);
        }
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String methodName = method.getName();
        if ("writeReplace".equals(methodName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("writeReplacing " + this._classMolder.getName() + " with identity " + this._identity));
            }
            if (!this._hasMaterialized) {
                try {
                    this._object = this.loadOnly();
                }
                catch (ObjectNotFoundException e) {
                    String msg = "Object with identity " + this._identity + " does not exist";
                    LOG.error((Object)msg, (Throwable)e);
                    throw new NotSerializableException(msg);
                }
                catch (PersistenceException e) {
                    String msg = "Problem serializing object with identity " + this._identity;
                    LOG.error((Object)msg, (Throwable)e);
                    throw new NotSerializableException(msg);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Serializing instance of " + this._object.getClass().getName()));
                LOG.debug((Object)("_object = " + this._object));
            }
            return this._object;
        }
        if ("interceptedClass".equals(methodName)) {
            return this._clazz;
        }
        if ("interceptedHasMaterialized".equals(methodName)) {
            return new Boolean(this._hasMaterialized);
        }
        if ("interceptedIdentity".equals(methodName)) {
            return this._identity;
        }
        if ("interceptedClassMolder".equals(methodName)) {
            return this._classMolder;
        }
        if ("getClass".equals(methodName)) {
            return method.invoke(obj, args);
        }
        if ("finalize".equals(methodName)) {
            return method.invoke(obj, args);
        }
        if (this._object == null) {
            this._object = this.load(obj);
        }
        if (this._object == null) {
            return null;
        }
        return method.invoke(this._object, args);
    }

    private Object loadOnly() throws PersistenceException {
        Object instance = null;
        if (LOG.isDebugEnabled() && this._classMolder != null) {
            LOG.debug((Object)("load object " + this._classMolder.getName() + " with id " + this._identity));
        }
        ProposedEntity proposedValue = new ProposedEntity(this._classMolder);
        proposedValue.setProposedEntityClass(this._clazz);
        proposedValue.setEntity(this._object);
        instance = this._tx.load(this._identity, proposedValue, this._accessMode);
        this._hasMaterialized = true;
        return instance;
    }

    private Object load(Object proxiedObject) throws PersistenceException, IllegalAccessException, InstantiationException {
        Object instance;
        block3: {
            instance = null;
            try {
                instance = this.loadOnly();
            }
            catch (ObjectNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("object not found -> " + ex.toString()));
                }
                if (!(proxiedObject instanceof Factory)) break block3;
                instance = proxiedObject.getClass().getSuperclass().newInstance();
            }
        }
        return instance;
    }
}

