/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.util.AbstractProperties;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public final class TransactionManagerFactoryRegistry {
    private static final Log LOG = LogFactory.getLog(TransactionManagerFactoryRegistry.class);
    private Map _factories = new HashMap();

    public TransactionManagerFactoryRegistry(AbstractProperties properties) {
        ClassLoader loader = properties.getApplicationClassLoader();
        Object[] objects = properties.getObjectArray("org.castor.transactionmanager.Factories", loader);
        for (int i = 0; i < objects.length; ++i) {
            TransactionManagerFactory factory = (TransactionManagerFactory)objects[i];
            this._factories.put(factory.getName(), factory);
        }
    }

    public String[] getTransactionManagerFactoryNames() {
        String[] names = new String[this._factories.size()];
        return this._factories.keySet().toArray(names);
    }

    public TransactionManagerFactory getTransactionManagerFactory(String name) throws TransactionManagerAcquireException {
        Object factory = this._factories.get(name);
        if (factory == null) {
            String msg = "The TransactionManagerFactory '" + name + "' " + "does not exist in the Castor properties file " + "and is therefore not supported.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return (TransactionManagerFactory)factory;
    }
}

