/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EModelElementImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;

public class EFactoryImpl
extends EModelElementImpl
implements EFactory {
    protected EPackage ePackage = null;
    protected static final DateFormat[] EDATE_FORMATS = new DateFormat[]{new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SafeSimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SafeSimpleDateFormat("yyyy-MM-dd")};
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected EFactoryImpl() {
    }

    protected EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEFactory();
    }

    public EPackage getEPackage() {
        return this.ePackage;
    }

    public void setEPackage(EPackage newEPackage) {
        if (newEPackage != this.ePackage) {
            NotificationChain msgs = null;
            if (this.ePackage != null) {
                InternalEObject internalEObject = (InternalEObject)((Object)this.ePackage);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EPackage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseRemove(this, 4, clazz, msgs);
            }
            if (newEPackage != null) {
                InternalEObject internalEObject = (InternalEObject)((Object)newEPackage);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EPackage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                msgs = internalEObject.eInverseAdd(this, 4, clazz, msgs);
            }
            if ((msgs = this.basicSetEPackage(newEPackage, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newEPackage, (Object)newEPackage));
        }
    }

    public NotificationChain basicSetEPackage(EPackage newEPackage, NotificationChain msgs) {
        EPackage oldEPackage = this.ePackage;
        this.ePackage = newEPackage;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldEPackage, (Object)newEPackage);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        block7: {
            if (featureID < 0) break block7;
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicAdd(otherEnd, msgs);
                }
                case 1: {
                    if (this.ePackage == null) return this.basicSetEPackage((EPackage)((Object)otherEnd), msgs);
                    InternalEObject internalEObject = (InternalEObject)((Object)this.ePackage);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.emf.ecore.EPackage");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    msgs = internalEObject.eInverseRemove(this, 4, clazz, msgs);
                    return this.basicSetEPackage((EPackage)((Object)otherEnd), msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer == null) return this.eBasicSetContainer(otherEnd, featureID, msgs);
        msgs = this.eBasicRemoveFromContainer(msgs);
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 0: {
                    return ((InternalEList)this.getEAnnotations()).basicRemove(otherEnd, msgs);
                }
                case 1: {
                    return this.basicSetEPackage(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public EObject create(EClass eClass) {
        if (this.getEPackage() != eClass.getEPackage()) {
            throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
        EList eSuperTypes = eClass.getESuperTypes();
        while (!eSuperTypes.isEmpty()) {
            EClass eSuperType = (EClass)eSuperTypes.get(0);
            if (eSuperType.getInstanceClass() != null) {
                EObject result = eSuperType.getEPackage().getEFactoryInstance().create(eSuperType);
                ((InternalEObject)result).eSetClass(eClass);
                return result;
            }
            eSuperTypes = eSuperType.getESuperTypes();
        }
        return this.basicCreate(eClass);
    }

    protected EObject basicCreate(EClass eClass) {
        EObjectImpl result = new EObjectImpl();
        result.eSetClass(eClass);
        return result;
    }

    public Object createFromString(EDataType eDataType, String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (this.getEPackage() != eDataType.getEPackage()) {
            throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
        if (eDataType instanceof EEnum) {
            return ((EEnum)eDataType).getEEnumLiteral(stringValue);
        }
        switch (ExtendedMetaData.INSTANCE.getWhiteSpaceFacet(eDataType)) {
            case 2: {
                stringValue = this.replaceWhiteSpace(stringValue);
                break;
            }
            case 3: {
                stringValue = this.collapseWhiteSpace(stringValue);
            }
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return EcoreUtil.createFromString(baseType, stringValue);
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(stringValue);
            while (stringTokenizer.hasMoreTokens()) {
                String item = stringTokenizer.nextToken();
                result.add(EcoreUtil.createFromString(itemType, item));
            }
            return result;
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            Iterator i = memberTypes.iterator();
            while (i.hasNext()) {
                EDataType memberType = (EDataType)i.next();
                try {
                    Object result = EcoreUtil.createFromString(memberType, stringValue);
                    if (result == null) continue;
                    return result;
                }
                catch (RuntimeException runtimeException) {}
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' does not match any member types of the union datatype '" + eDataType.getName() + "'");
        }
        Class c = EcoreUtil.wrapperClassFor(eDataType.getInstanceClass());
        if (c == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz) {
            char charValue = '\u0000';
            try {
                Integer value = new Integer(stringValue);
                charValue = (char)value.intValue();
            }
            catch (NumberFormatException numberFormatException) {
                char[] carray = stringValue.toCharArray();
                charValue = carray[0];
            }
            return new Character(charValue);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (c == clazz2) {
            int i = 0;
            while (i < EDATE_FORMATS.length) {
                try {
                    return EDATE_FORMATS[i].parse(stringValue);
                }
                catch (ParseException parseException) {
                    ++i;
                }
            }
            throw new IllegalArgumentException("The value '" + stringValue + "' is not a date formatted string of the form yyyy-MM-dd'T'HH:mm:ss'.'SSSZ or a valid subset thereof");
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> stringClass = clazz3;
        Class[] signature = new Class[]{stringClass};
        Constructor ctor = null;
        try {
            ctor = c.getConstructor(signature);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        Exception formatException = null;
        try {
            if (ctor != null) {
                Object[] ctorArgs = new Object[]{stringValue};
                return ctor.newInstance(ctorArgs);
            }
        }
        catch (InstantiationException e) {
            formatException = e;
        }
        catch (InvocationTargetException e) {
            formatException = e;
        }
        catch (IllegalAccessException e) {
            formatException = e;
        }
        Method valueOf = null;
        try {
            valueOf = c.getMethod("valueOf", signature);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        try {
            if (valueOf != null) {
                Object[] valueOfArgs = new Object[]{stringValue};
                return valueOf.invoke(null, valueOfArgs);
            }
        }
        catch (IllegalArgumentException e) {
            formatException = e;
        }
        catch (InvocationTargetException e) {
            formatException = e;
        }
        catch (IllegalAccessException e) {
            formatException = e;
        }
        String exceptionString = formatException != null ? formatException.toString() : "";
        throw new IllegalArgumentException("The value '" + stringValue + "' is invalid. " + exceptionString);
    }

    public String convertToString(EDataType eDataType, Object objectValue) {
        if (this.getEPackage() != eDataType.getEPackage()) {
            throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
        EDataType baseType = ExtendedMetaData.INSTANCE.getBaseType(eDataType);
        if (baseType != null) {
            return EcoreUtil.convertToString(baseType, objectValue);
        }
        EDataType itemType = ExtendedMetaData.INSTANCE.getItemType(eDataType);
        if (itemType != null) {
            if (objectValue == null) {
                return null;
            }
            List list = (List)objectValue;
            if (list.isEmpty()) {
                return "";
            }
            StringBuffer result = new StringBuffer();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object item = i.next();
                result.append(EcoreUtil.convertToString(itemType, item));
                result.append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        List memberTypes = ExtendedMetaData.INSTANCE.getMemberTypes(eDataType);
        if (!memberTypes.isEmpty()) {
            Iterator i = memberTypes.iterator();
            while (i.hasNext()) {
                EDataType memberType = (EDataType)i.next();
                if (!memberType.isInstance(objectValue)) continue;
                try {
                    String result = EcoreUtil.convertToString(memberType, objectValue);
                    if (result == null) continue;
                    return result;
                }
                catch (Exception exception) {}
            }
            throw new IllegalArgumentException("Invalid value: '" + objectValue + "' for datatype :" + eDataType.getName());
        }
        if (objectValue == null) {
            return null;
        }
        if (objectValue instanceof Character) {
            char charInt = ((Character)objectValue).charValue();
            Integer value = new Integer(charInt);
            return value.toString();
        }
        Class<?> clazz = objectValue.getClass();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return EDATE_FORMATS[0].format((Date)objectValue);
        }
        return objectValue.toString();
    }

    protected String replaceWhiteSpace(String value) {
        return XMLTypeUtil.normalize(value, false);
    }

    protected String collapseWhiteSpace(String value) {
        return XMLTypeUtil.normalize(value, true);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getEAnnotations();
            }
            case 1: {
                return this.getEPackage();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.eAnnotations != null && !this.eAnnotations.isEmpty();
            }
            case 1: {
                return this.ePackage != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                this.getEAnnotations().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setEPackage((EPackage)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.getEAnnotations().clear();
                return;
            }
            case 1: {
                this.setEPackage(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    private static class SafeSimpleDateFormat
    extends SimpleDateFormat {
        public SafeSimpleDateFormat(String pattern) {
            super(pattern);
        }

        public synchronized Date parse(String source) throws ParseException {
            return super.parse(source);
        }

        public synchronized StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return super.format(date, toAppendTo, fieldPosition);
        }
    }
}

