/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class ECrossReferenceEList
extends EContentsEList {
    public ECrossReferenceEList(EObject eObject) {
        super(eObject, ((EClassImpl.FeatureSubsetSupplier)((Object)eObject.eClass().getEAllStructuralFeatures())).crossReferences());
    }

    protected ECrossReferenceEList(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
        super(eObject, eStructuralFeatures);
    }

    protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
        if (FeatureMapUtil.isFeatureMap(eStructuralFeature)) {
            return true;
        }
        EReference eReference = (EReference)eStructuralFeature;
        return !eReference.isContainment() && !eReference.isContainer();
    }

    protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            return !eReference.isContainment() && !eReference.isContainer();
        }
        return false;
    }

    protected ListIterator newListIterator() {
        return this.resolve() ? new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures) : new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public List basicList() {
        return new ECrossReferenceEList(this.eObject, this.eStructuralFeatures){

            protected boolean resolve() {
                return false;
            }
        };
    }

    public Iterator basicIterator() {
        if (this.eStructuralFeatures == null) {
            return EContentsEList.FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public ListIterator basicListIterator() {
        if (this.eStructuralFeatures == null) {
            return EContentsEList.FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
    }

    public ListIterator basicListIterator(int index) {
        if (this.eStructuralFeatures == null) {
            if (index < 0 || index > 1) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=0");
            }
            return EContentsEList.FeatureIteratorImpl.EMPTY_ITERATOR;
        }
        FeatureIteratorImpl result = new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures);
        int i = 0;
        while (i < index) {
            result.next();
            ++i;
        }
        return result;
    }

    public static class FeatureIteratorImpl
    extends EContentsEList.FeatureIteratorImpl {
        public FeatureIteratorImpl(EObject eObject) {
            super(eObject, (EStructuralFeature[])((BasicEList)eObject.eClass().getEAllReferences()).data());
        }

        public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            if (FeatureMapUtil.isFeatureMap(eStructuralFeature)) {
                return true;
            }
            EReference eReference = (EReference)eStructuralFeature;
            return !eReference.isContainment() && !eReference.isContainer();
        }

        protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                return !eReference.isContainment() && !eReference.isContainer();
            }
            return false;
        }
    }

    public static class ResolvingFeatureIteratorImpl
    extends FeatureIteratorImpl {
        public ResolvingFeatureIteratorImpl(EObject eObject) {
            super(eObject);
        }

        public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures) {
            super(eObject, eStructuralFeatures);
        }

        protected boolean resolve() {
            return true;
        }
    }
}

