/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupContent;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDNamespaceConstraintCategory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDAttributeGroupContentImpl;
import org.eclipse.xsd.impl.XSDAttributeUseImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDRedefinableComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.impl.XSDWildcardImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDAttributeGroupDefinitionImpl
extends XSDRedefinableComponentImpl
implements XSDAttributeGroupDefinition {
    protected static final boolean ATTRIBUTE_GROUP_DEFINITION_REFERENCE_EDEFAULT = false;
    protected XSDAnnotation annotation = null;
    protected EList contents = null;
    protected EList attributeUses = null;
    protected XSDWildcard attributeWildcardContent = null;
    protected XSDWildcard attributeWildcard = null;
    protected XSDAttributeGroupDefinition resolvedAttributeGroupDefinition = this;
    protected XSDWildcard syntheticWildcard = null;
    protected int analysisState;
    protected XSDWildcardImpl effectiveWildcard;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static XSDAttributeGroupDefinition createAttributeGroupDefinition(Node node) {
        if (XSDConstants.nodeType(node) == 6) {
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
            xsdAttributeGroupDefinition.setElement((Element)node);
            return xsdAttributeGroupDefinition;
        }
        return null;
    }

    protected XSDAttributeGroupDefinitionImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDAttributeGroupDefinition();
    }

    public Boolean getAttributeGroupDefinitionReference() {
        return this.isAttributeGroupDefinitionReference() ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element createElement() {
        Element newElement = this.createElement(6);
        this.setElement(newElement);
        Iterator contents = this.getContents().iterator();
        while (contents.hasNext()) {
            XSDAttributeGroupContent xsdAttributeGroupContent = (XSDAttributeGroupContent)contents.next();
            if (xsdAttributeGroupContent instanceof XSDAttributeGroupDefinition) {
                XSDAttributeGroupDefinition xsdAttributeGroupDefinition = (XSDAttributeGroupDefinition)xsdAttributeGroupContent;
                Element attributeGroupDefinitionElement = ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).createElement();
                newElement.appendChild(attributeGroupDefinitionElement);
                continue;
            }
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdAttributeGroupContent;
            Element attributeUseElement = ((XSDConcreteComponentImpl)((Object)xsdAttributeUse)).createElement();
            newElement.appendChild(attributeUseElement);
        }
        return newElement;
    }

    protected void patch() {
        XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition;
        this.analysisState = 0;
        super.patch();
        XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
        if (theResolvedAttributeGroupDefinition != this && (this.forceResolve || theResolvedAttributeGroupDefinition.getContainer() == null) && (newResolvedAttributeGroupDefinition = this.resolveAttributeGroupDefinition(theResolvedAttributeGroupDefinition.getTargetNamespace(), theResolvedAttributeGroupDefinition.getName())).getContainer() != null) {
            this.handleNewResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
        }
    }

    protected boolean analyze() {
        switch (this.analysisState) {
            case 0: {
                this.analysisState = 1;
                super.analyze();
                this.handleAnalysis();
                if (this.analysisState == 1) {
                    this.analysisState = 2;
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
        }
        this.analysisState = 3;
        return false;
    }

    protected void handleAnalysis() {
        List newAttributeUses = XSDAttributeGroupDefinitionImpl.getAttributeUses(this.getContents(), Collections.EMPTY_LIST);
        ArrayList remainingAttributeUses = new ArrayList(this.getAttributeUses());
        remainingAttributeUses.removeAll(newAttributeUses);
        if (!remainingAttributeUses.isEmpty()) {
            this.getAttributeUses().removeAll(remainingAttributeUses);
        }
        XSDAttributeGroupDefinitionImpl.setListContentAndOrder(this.getAttributeUses(), newAttributeUses);
        XSDWildcard newAttributeWildcard = XSDAttributeGroupDefinitionImpl.getAttributeWildcard(null, this.getAttributeWildcardContent(), this.getContents());
        if (newAttributeWildcard != null && newAttributeWildcard.getContainer() == null) {
            if (this.effectiveWildcard == null) {
                this.effectiveWildcard = (XSDWildcardImpl)this.getXSDFactory().createXSDWildcard();
                this.setSyntheticWildcard(this.effectiveWildcard);
            }
            this.effectiveWildcard.setLike(newAttributeWildcard);
            newAttributeWildcard = this.effectiveWildcard;
        }
        if (newAttributeWildcard != this.getAttributeWildcard()) {
            this.setAttributeWildcard(newAttributeWildcard);
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, new String[]{"id", "name"});
                this.checkComplexContent("namedAttributeGroup", "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement);
            } else {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, new String[]{"id", "ref"});
                this.checkComplexContent("attributeGroupRef", "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement);
            }
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, "id", false);
        }
        if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
            if (this.isAttributeGroupDefinitionReference()) {
                if (theElement == null) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "ref");
                }
            } else {
                this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, "name", true);
                XSDWildcard theAttributeWildcard = this.getAttributeWildcard();
                if (theAttributeWildcard != null && theAttributeWildcard.getNamespaceConstraint().isEmpty() && theAttributeWildcard.getNamespaceConstraintCategory() == XSDNamespaceConstraintCategory.NOT_LITERAL) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute_group.2");
                }
                if (this.isCircular()) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute_group.3");
                }
                XSDAttributeDeclaration idAttribute = null;
                HashSet<String> uris = new HashSet<String>();
                Iterator i = this.getAttributeUses().iterator();
                while (i.hasNext()) {
                    XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)i.next();
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttributeUse.getAttributeDeclaration();
                    if (!uris.add(xsdAttributeDeclaration.getURI())) {
                        this.getDiagnosticTarget(xsdAttributeUse).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attrGroup.2", xsdAttributeDeclaration.getURI());
                    }
                    if (!XSDConstants.isOrIsDerivedFromID(xsdAttributeDeclaration.getTypeDefinition())) continue;
                    if (idAttribute != null) {
                        this.getDiagnosticTarget(xsdAttributeUse).createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attrGroup.3", xsdAttributeDeclaration.getURI(), idAttribute.getURI());
                        continue;
                    }
                    idAttribute = xsdAttributeDeclaration;
                }
            }
        } else if (this.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
            if (theResolvedAttributeGroupDefinition.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedAttributeGroupDefinition_message", theResolvedAttributeGroupDefinition.getURI());
            }
        } else if (theElement == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "name");
        }
    }

    public static List getAttributeUses(Collection xsdAttributeGroupContents, Collection xsdAttributeUses) {
        ArrayList<XSDAttributeUse> result = new ArrayList<XSDAttributeUse>();
        HashSet<String> localAttributeUses = new HashSet<String>();
        Iterator attributeContents = xsdAttributeGroupContents.iterator();
        while (attributeContents.hasNext()) {
            XSDAttributeGroupContent xsdAttributeGroupContent = (XSDAttributeGroupContent)attributeContents.next();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupContent)).analyze();
            if (xsdAttributeGroupContent instanceof XSDAttributeUse) {
                XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)xsdAttributeGroupContent;
                if (xsdAttributeUse.getUse() != XSDAttributeUseCategory.PROHIBITED_LITERAL) {
                    result.add(xsdAttributeUse);
                }
                localAttributeUses.add(xsdAttributeUse.getAttributeDeclaration().getURI());
                continue;
            }
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)xsdAttributeGroupContent).getResolvedAttributeGroupDefinition();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).analyze();
            result.addAll(xsdAttributeGroupDefinition.getAttributeUses());
        }
        Iterator attributeUses = xsdAttributeUses.iterator();
        while (attributeUses.hasNext()) {
            XSDAttributeUse xsdAttributeUse = (XSDAttributeUse)attributeUses.next();
            if (localAttributeUses.contains(xsdAttributeUse.getAttributeDeclaration().getURI())) continue;
            result.add(xsdAttributeUse);
        }
        return XSDAttributeUseImpl.sortAttributeUses(result);
    }

    public static XSDWildcard getAttributeWildcard(XSDWildcard baseWildcard, XSDWildcard localWildcard, Collection xsdAttributeGroupContents) {
        Iterator attributeContents = xsdAttributeGroupContents.iterator();
        while (attributeContents.hasNext()) {
            XSDAttributeGroupContent xsdAttributeGroupContent = (XSDAttributeGroupContent)attributeContents.next();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupContent)).analyze();
            if (!(xsdAttributeGroupContent instanceof XSDAttributeGroupDefinition)) continue;
            XSDAttributeGroupDefinition xsdAttributeGroupDefinition = ((XSDAttributeGroupDefinition)xsdAttributeGroupContent).getResolvedAttributeGroupDefinition();
            ((XSDConcreteComponentImpl)((Object)xsdAttributeGroupDefinition)).analyze();
            XSDWildcard attributeGroupWildcard = xsdAttributeGroupDefinition.getAttributeWildcard();
            if (attributeGroupWildcard == null) continue;
            if (localWildcard == null) {
                localWildcard = attributeGroupWildcard;
                continue;
            }
            if ((localWildcard = localWildcard.attributeWildcardIntersection(attributeGroupWildcard)) == null) {
                return null;
            }
            if (!localWildcard.getNamespaceConstraint().isEmpty() || localWildcard.getNamespaceConstraintCategory() != XSDNamespaceConstraintCategory.NOT_LITERAL) continue;
            return localWildcard;
        }
        if (localWildcard == null) {
            localWildcard = baseWildcard;
        } else if (baseWildcard != null) {
            localWildcard = localWildcard.attributeWildcardUnion(baseWildcard);
        }
        return localWildcard;
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition = this;
        if (changedElement.hasAttributeNS(null, "ref")) {
            newResolvedAttributeGroupDefinition = this.resolveAttributeGroupDefinitionURI(XSDConstants.lookupQNameForAttribute(changedElement, "ref"));
        }
        this.handleNewResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
    }

    protected void handleNewResolvedAttributeGroupDefinition(XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition) {
        XSDAttributeGroupDefinition redefinedAttributeGroupDefinition;
        XSDSchema redefinedSchema;
        if (newResolvedAttributeGroupDefinition == this.getContainer() && newResolvedAttributeGroupDefinition.getContainer() instanceof XSDRedefine && (redefinedSchema = ((XSDRedefine)newResolvedAttributeGroupDefinition.getContainer()).getIncorporatedSchema()) != null && (redefinedAttributeGroupDefinition = (XSDAttributeGroupDefinition)((XSDSchemaImpl)redefinedSchema).getRedefinitionMap().get(newResolvedAttributeGroupDefinition)) != null) {
            newResolvedAttributeGroupDefinition = redefinedAttributeGroupDefinition;
        }
        if (newResolvedAttributeGroupDefinition != this.getResolvedAttributeGroupDefinition()) {
            this.setResolvedAttributeGroupDefinition(newResolvedAttributeGroupDefinition);
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
        if (xsdAnnotation != null) {
            newContents.add(xsdAnnotation);
        } else {
            XSDAttributeGroupContent xsdAttributeGroupContent = XSDAttributeGroupContentImpl.createAttributeGroupContent(child);
            if (xsdAttributeGroupContent != null) {
                newContents.add(xsdAttributeGroupContent);
            } else {
                XSDWildcard xsdWildcard = XSDWildcardImpl.createWildcard(child);
                if (xsdWildcard != null) {
                    newContents.add(xsdWildcard);
                }
            }
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        int lastIndex;
        Object last;
        this.handleAnnotationReconciliation(XSDPackage.eINSTANCE.getXSDAttributeGroupDefinition_Annotation(), newContents, remainingContents);
        XSDWildcard newAttributeWildcard = null;
        if (!newContents.isEmpty() && (last = newContents.get(lastIndex = newContents.size() - 1)) instanceof XSDWildcard) {
            newAttributeWildcard = (XSDWildcard)last;
            if (XSDConstants.nodeType(newAttributeWildcard.getElement()) == 3) {
                newContents.remove(lastIndex);
            } else {
                newAttributeWildcard = null;
            }
        }
        if (newAttributeWildcard != this.getAttributeWildcardContent()) {
            remainingContents.remove(this.getAttributeWildcardContent());
            this.setAttributeWildcardContent(newAttributeWildcard);
        }
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        if (!newContents.isEmpty()) {
            Iterator i = newContents.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof XSDAttributeGroupContent) continue;
                i.remove();
            }
            XSDAttributeGroupDefinitionImpl.setListContentAndOrder(this.getContents(), newContents);
        }
    }

    protected void changeReference(EReference eReference) {
        XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition;
        if (this.isReconciling) {
            return;
        }
        super.changeReference(eReference);
        Element theElement = this.getElement();
        if (theElement != null && (eReference == null || eReference == XSDPackage.eINSTANCE.getXSDAttributeGroupDefinition_ResolvedAttributeGroupDefinition()) && (theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition()) != this) {
            this.niceSetAttributeURIValue(theElement, "ref", theResolvedAttributeGroupDefinition.getURI());
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeGroupDefinition_Contents()) {
            this.traverseToRootForPatching();
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeGroupDefinition_Contents()) {
            this.traverseToRootForPatching();
        }
    }

    public boolean isAttributeGroupDefinitionReference() {
        return this != this.getResolvedAttributeGroupDefinition();
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -14, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -14, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public EList getContents() {
        if (this.contents == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.xsd.XSDAttributeGroupContent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.contents = new EObjectContainmentEList(clazz, this, 14);
        }
        return this.contents;
    }

    public EList getAttributeUses() {
        if (this.attributeUses == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.xsd.XSDAttributeUse");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.attributeUses = new EObjectEList(clazz, this, 15);
        }
        return this.attributeUses;
    }

    public XSDWildcard getAttributeWildcardContent() {
        return this.attributeWildcardContent;
    }

    public void setAttributeWildcardContent(XSDWildcard newAttributeWildcardContent) {
        if (newAttributeWildcardContent != this.attributeWildcardContent) {
            NotificationChain msgs = null;
            if (this.attributeWildcardContent != null) {
                msgs = ((InternalEObject)((Object)this.attributeWildcardContent)).eInverseRemove(this, -17, null, msgs);
            }
            if (newAttributeWildcardContent != null) {
                msgs = ((InternalEObject)((Object)newAttributeWildcardContent)).eInverseAdd(this, -17, null, msgs);
            }
            if ((msgs = this.basicSetAttributeWildcardContent(newAttributeWildcardContent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newAttributeWildcardContent, (Object)newAttributeWildcardContent));
        }
    }

    public NotificationChain basicSetAttributeWildcardContent(XSDWildcard newAttributeWildcardContent, NotificationChain msgs) {
        XSDWildcard oldAttributeWildcardContent = this.attributeWildcardContent;
        this.attributeWildcardContent = newAttributeWildcardContent;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldAttributeWildcardContent, (Object)newAttributeWildcardContent);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public XSDWildcard getAttributeWildcard() {
        return this.attributeWildcard;
    }

    public void setAttributeWildcard(XSDWildcard newAttributeWildcard) {
        XSDWildcard oldAttributeWildcard = this.attributeWildcard;
        this.attributeWildcard = newAttributeWildcard;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldAttributeWildcard, (Object)this.attributeWildcard));
        }
    }

    public XSDAttributeGroupDefinition getResolvedAttributeGroupDefinition() {
        return this.resolvedAttributeGroupDefinition;
    }

    public void setResolvedAttributeGroupDefinition(XSDAttributeGroupDefinition newResolvedAttributeGroupDefinition) {
        XSDAttributeGroupDefinition oldResolvedAttributeGroupDefinition = this.resolvedAttributeGroupDefinition;
        this.resolvedAttributeGroupDefinition = newResolvedAttributeGroupDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldResolvedAttributeGroupDefinition, (Object)this.resolvedAttributeGroupDefinition));
        }
    }

    public XSDWildcard getSyntheticWildcard() {
        return this.syntheticWildcard;
    }

    public NotificationChain basicSetSyntheticWildcard(XSDWildcard newSyntheticWildcard, NotificationChain msgs) {
        XSDWildcard oldSyntheticWildcard = this.syntheticWildcard;
        this.syntheticWildcard = newSyntheticWildcard;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldSyntheticWildcard, (Object)newSyntheticWildcard);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public void setSyntheticWildcard(XSDWildcard newSyntheticWildcard) {
        if (newSyntheticWildcard != this.syntheticWildcard) {
            NotificationChain msgs = null;
            if (this.syntheticWildcard != null) {
                msgs = ((InternalEObject)((Object)this.syntheticWildcard)).eInverseRemove(this, -20, null, msgs);
            }
            if (newSyntheticWildcard != null) {
                msgs = ((InternalEObject)((Object)newSyntheticWildcard)).eInverseAdd(this, -20, null, msgs);
            }
            if ((msgs = this.basicSetSyntheticWildcard(newSyntheticWildcard, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 19, (Object)newSyntheticWildcard, (Object)newSyntheticWildcard));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 13: {
                    return this.basicSetAnnotation(null, msgs);
                }
                case 14: {
                    return ((InternalEList)this.getContents()).basicRemove(otherEnd, msgs);
                }
                case 16: {
                    return this.basicSetAttributeWildcardContent(null, msgs);
                }
                case 19: {
                    return this.basicSetSyntheticWildcard(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getTargetNamespace();
            }
            case 7: {
                return this.getAliasName();
            }
            case 8: {
                return this.getURI();
            }
            case 9: {
                return this.getAliasURI();
            }
            case 10: {
                return this.getQName();
            }
            case 11: {
                return this.isCircular() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isAttributeGroupDefinitionReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.getAnnotation();
            }
            case 14: {
                return this.getContents();
            }
            case 15: {
                return this.getAttributeUses();
            }
            case 16: {
                return this.getAttributeWildcardContent();
            }
            case 17: {
                return this.getAttributeWildcard();
            }
            case 18: {
                return this.getResolvedAttributeGroupDefinition();
            }
            case 19: {
                return this.getSyntheticWildcard();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setTargetNamespace((String)newValue);
                return;
            }
            case 13: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 14: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getAttributeUses().clear();
                this.getAttributeUses().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setAttributeWildcardContent((XSDWildcard)newValue);
                return;
            }
            case 17: {
                this.setAttributeWildcard((XSDWildcard)newValue);
                return;
            }
            case 18: {
                this.setResolvedAttributeGroupDefinition((XSDAttributeGroupDefinition)newValue);
                return;
            }
            case 19: {
                this.setSyntheticWildcard((XSDWildcard)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetNamespace(TARGET_NAMESPACE_EDEFAULT);
                return;
            }
            case 13: {
                this.setAnnotation(null);
                return;
            }
            case 14: {
                this.getContents().clear();
                return;
            }
            case 15: {
                this.getAttributeUses().clear();
                return;
            }
            case 16: {
                this.setAttributeWildcardContent(null);
                return;
            }
            case 17: {
                this.setAttributeWildcard(null);
                return;
            }
            case 18: {
                this.setResolvedAttributeGroupDefinition(null);
                return;
            }
            case 19: {
                this.setSyntheticWildcard(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 7: {
                return ALIAS_NAME_EDEFAULT == null ? this.getAliasName() != null : !ALIAS_NAME_EDEFAULT.equals(this.getAliasName());
            }
            case 8: {
                return URI_EDEFAULT == null ? this.getURI() != null : !URI_EDEFAULT.equals(this.getURI());
            }
            case 9: {
                return ALIAS_URI_EDEFAULT == null ? this.getAliasURI() != null : !ALIAS_URI_EDEFAULT.equals(this.getAliasURI());
            }
            case 10: {
                return QNAME_EDEFAULT == null ? this.getQName() != null : !QNAME_EDEFAULT.equals(this.getQName());
            }
            case 11: {
                return this.isCircular();
            }
            case 12: {
                return this.isAttributeGroupDefinitionReference();
            }
            case 13: {
                return this.annotation != null;
            }
            case 14: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 15: {
                return this.attributeUses != null && !this.attributeUses.isEmpty();
            }
            case 16: {
                return this.attributeWildcardContent != null;
            }
            case 17: {
                return this.attributeWildcard != null;
            }
            case 18: {
                return this.resolvedAttributeGroupDefinition != null;
            }
            case 19: {
                return this.syntheticWildcard != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String getQName() {
        XSDAttributeGroupDefinition resolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
        if (resolvedAttributeGroupDefinition == this) {
            return super.getQName();
        }
        return resolvedAttributeGroupDefinition.getQName(this);
    }

    public boolean isNamedComponentReference() {
        return this.isAttributeGroupDefinitionReference();
    }

    public XSDNamedComponent getResolvedNamedComponent() {
        return this.getResolvedAttributeGroupDefinition();
    }

    public boolean isCircular() {
        return this.analysisState == 3;
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeGroupDefinitionImpl clonedAttributeGroupDefinition = (XSDAttributeGroupDefinitionImpl)this.getXSDFactory().createXSDAttributeGroupDefinition();
        clonedAttributeGroupDefinition.isReconciling = true;
        if (this.isAttributeGroupDefinitionReference()) {
            XSDAttributeGroupDefinition theResolvedAttributeGroupDefinition = this.getResolvedAttributeGroupDefinition();
            clonedAttributeGroupDefinition.setResolvedAttributeGroupDefinition(this.createUnresolvedAttributeGroupDefinition(theResolvedAttributeGroupDefinition.getTargetNamespace(), theResolvedAttributeGroupDefinition.getName()));
        } else if (this.getName() != null) {
            clonedAttributeGroupDefinition.setName(this.getName());
        }
        if (deep) {
            if (this.getAnnotation() != null) {
                clonedAttributeGroupDefinition.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(true, shareDOM));
            }
            if (!this.getContents().isEmpty()) {
                clonedAttributeGroupDefinition.getContents().addAll(XSDAttributeGroupDefinitionImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
            }
            if (this.getAttributeWildcardContent() != null) {
                clonedAttributeGroupDefinition.setAttributeWildcardContent((XSDWildcard)this.getAttributeWildcardContent().cloneConcreteComponent(true, shareDOM));
            }
        }
        if (shareDOM && this.getElement() != null) {
            clonedAttributeGroupDefinition.setElement(this.getElement());
        }
        clonedAttributeGroupDefinition.isReconciling = shareDOM;
        return clonedAttributeGroupDefinition;
    }
}

