/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDMinFacetImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDMinInclusiveFacetImpl
extends XSDMinFacetImpl
implements XSDMinInclusiveFacet {
    public static XSDMinInclusiveFacet createMinInclusiveFacet(Node node) {
        if (XSDConstants.nodeType(node) == 27) {
            XSDMinInclusiveFacet xsdMinInclusiveFacet = XSDFactory.eINSTANCE.createXSDMinInclusiveFacet();
            xsdMinInclusiveFacet.setElement((Element)node);
            return xsdMinInclusiveFacet;
        }
        return null;
    }

    protected XSDMinInclusiveFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDMinInclusiveFacet();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.isInclusive() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isExclusive() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
            case 11: {
                this.setValue(newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.unsetFixed();
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.isSetFixed();
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.isInclusive();
            }
            case 13: {
                return this.isExclusive();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public Element createElement() {
        Element newElement = this.createElement(27);
        this.setElement(newElement);
        return newElement;
    }

    protected boolean analyze() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition;
        super.analyze();
        String theLexicalValue = this.getLexicalValue();
        Object newValue = null;
        if (theLexicalValue != null && (xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(theLexicalValue);
            }
            catch (RuntimeException runtimeException) {}
        }
        if (newValue == null ? this.getValue() != null : !newValue.equals(this.getValue())) {
            this.setValue(newValue);
        }
        return true;
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        if (eAttribute == XSDPackage.eINSTANCE.getXSDFacet_LexicalValue()) {
            this.traverseToRootForAnalysis();
        }
    }

    public boolean isConstraintSatisfied(Object value) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        if (xsdSimpleTypeDefinition != null) {
            return xsdSimpleTypeDefinition.compareValues(value, this.getValue()) >= 0;
        }
        return false;
    }

    public Object getEffectiveValue() {
        return this.getValue();
    }

    public boolean isInclusive() {
        return true;
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDMinInclusiveFacetImpl clonedMinInclusiveFacet = (XSDMinInclusiveFacetImpl)this.getXSDFactory().createXSDMinInclusiveFacet();
        clonedMinInclusiveFacet.isReconciling = true;
        if (this.getLexicalValue() != null) {
            clonedMinInclusiveFacet.setLexicalValue(this.getLexicalValue());
        }
        if (this.isSetFixed()) {
            clonedMinInclusiveFacet.setFixed(this.isFixed());
        }
        if (deep && this.getAnnotation() != null) {
            clonedMinInclusiveFacet.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
        }
        if (shareDOM && this.getElement() != null) {
            clonedMinInclusiveFacet.setElement(this.getElement());
        }
        clonedMinInclusiveFacet.isReconciling = shareDOM;
        return clonedMinInclusiveFacet;
    }
}

