/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.descriptors;

import java.util.List;
import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.descriptors.JDODescriptorJClass;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.nature.JDOClassInfoNature;
import org.exolab.castor.builder.info.nature.JDOFieldInfoNature;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.info.nature.relation.JDOOneToManyNature;
import org.exolab.castor.builder.info.nature.relation.JDOOneToOneNature;
import org.exolab.castor.builder.types.XSList;
import org.exolab.castor.builder.types.XSType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JPrimitiveType;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JDOClassDescriptorFactory {
    private final BuilderConfiguration _config;
    private String _fields = null;
    private String _identities = null;

    public JDOClassDescriptorFactory(BuilderConfiguration config) {
        if (config == null) {
            String err = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._config = config;
    }

    public JClass createSource(ClassInfo classInfo) {
        if (!this.checkClassInfoNature(classInfo)) {
            return null;
        }
        JClass jClass = classInfo.getJClass();
        String descriptorClassName = this.getQualifiedJDODescriptorClassName(jClass.getName());
        JDODescriptorJClass classDesc = new JDODescriptorJClass(this._config, descriptorClassName, jClass);
        JDOClassInfoNature cNature = new JDOClassInfoNature(classInfo);
        JConstructor ctor = classDesc.getConstructor(0);
        JSourceCode jsc = ctor.getSourceCode();
        jsc = this.createClassInfoPart(classInfo, jsc);
        for (int i = 0; i < classInfo.getElementFields().length; ++i) {
            FieldInfo fInfo = classInfo.getElementFields()[i];
            if (!this.checkFieldInfoNatures(fInfo)) continue;
            jsc = fInfo.hasNature(JDOOneToOneNature.class.getName()) ? this.createOneToOneFieldInfoPart(fInfo, jsc) : (fInfo.hasNature(JDOOneToManyNature.class.getName()) ? this.createOneToManyFieldInfoPart(fInfo, jsc) : this.createEntityFieldInfoPart(fInfo, jsc));
        }
        this._fields = this.setFields(classInfo.getElementFields());
        this._identities = this.setIdentities(cNature.getPrimaryKeys());
        jsc.add("");
        jsc.add("setFields(new FieldDescriptor[] {" + this._fields + "});");
        jsc.add("setIdentities(new FieldDescriptor[] {" + this._identities + "});");
        return classDesc;
    }

    private String getQualifiedJDODescriptorClassName(String name) {
        String descPackage = JNaming.getPackageFromClassName((String)name);
        String descClassName = JNaming.getLocalNameFromClassName((String)name);
        descPackage = descPackage != null && descPackage.length() > 0 ? descPackage + "." + "jdo_descriptors" + "." : "";
        return descPackage + descClassName + "JDODescriptor";
    }

    private static String toUpperCaseFirstLetter(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private String setFields(FieldInfo[] fInfos) {
        String str = "";
        for (int i = 0; i < fInfos.length; ++i) {
            FieldInfo fInfo = fInfos[i];
            ClassInfo cInfo = fInfo.getDeclaringClassInfo();
            JDOClassInfoNature cNature = new JDOClassInfoNature(cInfo);
            if (cNature.getPrimaryKeys() != null && cNature.getPrimaryKeys().contains(new XMLInfoNature(fInfo).getNodeName())) continue;
            str = str.equals("") ? str + new XMLInfoNature(fInfo).getNodeName() + "FieldDescr" : str + "," + new XMLInfoNature(fInfo).getNodeName() + "FieldDescr";
        }
        return str;
    }

    private String setIdentities(List<?> primaryKeys) {
        String identities = "";
        Object[] pkArray = null;
        if (primaryKeys != null) {
            pkArray = primaryKeys.toArray();
            for (int i = 0; i < pkArray.length; ++i) {
                identities = identities.equals("") ? identities + pkArray[i] + "FieldDescr" : identities + "," + pkArray[i] + "FieldDescr";
            }
        }
        return identities;
    }

    private boolean checkClassInfoNature(ClassInfo cInfo) {
        if (cInfo.hasNature(JDOClassInfoNature.class.getName())) {
            JDOClassInfoNature cNature = new JDOClassInfoNature(cInfo);
            return cNature.getAccessMode() != null && cNature.getPrimaryKeys() != null && !cNature.getPrimaryKeys().isEmpty() && cNature.getTableName() != null && cNature.getTableName().length() != 0;
        }
        return false;
    }

    private boolean checkFieldInfoNatures(FieldInfo fInfo) {
        if (!fInfo.hasNature(XMLInfoNature.class.getName())) {
            return false;
        }
        if (fInfo.hasNature(JDOFieldInfoNature.class.getName())) {
            JDOFieldInfoNature fNature = new JDOFieldInfoNature(fInfo);
            return fNature.getColumnName() != null && fNature.getColumnName().length() != 0 && fNature.getColumnType() != null;
        }
        if (fInfo.hasNature(JDOOneToOneNature.class.getName())) {
            JDOOneToOneNature oneNature = new JDOOneToOneNature(fInfo);
            return oneNature.getForeignKeys().size() == 1;
        }
        if (fInfo.hasNature(JDOOneToManyNature.class.getName())) {
            JDOOneToManyNature manyNature = new JDOOneToManyNature(fInfo);
            return manyNature.getForeignKeys().size() == 1;
        }
        return false;
    }

    private JSourceCode createClassInfoPart(ClassInfo classInfo, JSourceCode jsc) {
        JDOClassInfoNature cNature = new JDOClassInfoNature(classInfo);
        jsc.add("");
        jsc.add("addNature(ClassDescriptorJDONature.class.getName());");
        jsc.add("ClassDescriptorJDONature jdoNature = new ClassDescriptorJDONature(this);");
        String tableName = cNature.getTableName();
        jsc.add("jdoNature.setTableName(\"" + tableName + "\");");
        String className = classInfo.getJClass().getLocalName();
        if (className != null && className.length() > 0) {
            jsc.add("setJavaClass(");
            jsc.append(className);
            jsc.append(".class);");
        }
        String accessMode = cNature.getAccessMode().getName();
        jsc.add("jdoNature.setAccessMode(AccessMode.valueOf(\"" + accessMode + "\"));");
        String fullName = classInfo.getJClass().getName();
        if (fullName != null && fullName.length() > 0) {
            jsc.add("jdoNature.addCacheParam(\"name\", \"");
            jsc.append(fullName);
            jsc.append("\");");
        }
        jsc.add("");
        jsc.add("mapping.setAccess(ClassMappingAccessType.valueOf(\"");
        jsc.append(accessMode + "\"));");
        jsc.add("mapping.setAutoComplete(true);");
        if (fullName != null && fullName.length() > 0) {
            jsc.add("mapping.setName(\"");
            jsc.append(fullName);
            jsc.append("\");");
        }
        jsc.add("mapping.setClassChoice(choice);");
        String table = cNature.getTableName();
        jsc.add("mapTo.setTable(\"" + table + "\");");
        jsc.add("mapping.setMapTo(mapTo);");
        jsc.add("setMapping(mapping);");
        return jsc;
    }

    private JSourceCode createEntityFieldInfoPart(FieldInfo fInfo, JSourceCode jsc) {
        JDOFieldInfoNature fNature = new JDOFieldInfoNature(fInfo);
        JDOClassInfoNature cNature = new JDOClassInfoNature(fInfo.getDeclaringClassInfo());
        XMLInfoNature xmlNature = new XMLInfoNature(fInfo);
        String name = xmlNature.getNodeName();
        jsc.add("");
        jsc.add("//" + name + " field");
        jsc.add("String " + name + "FieldName = \"" + name + "\";");
        jsc.add("FieldDescriptorImpl " + name + "FieldDescr;");
        jsc.add("FieldMapping " + name + "FM = new FieldMapping();");
        String type = null;
        XSType schemaType = xmlNature.getSchemaType();
        JType javaType = schemaType.getJType();
        type = ((Object)javaType).toString();
        String wrapperType = null;
        wrapperType = javaType instanceof JPrimitiveType ? ((JPrimitiveType)javaType).getWrapperName() : type;
        if (type != null && type.length() > 0) {
            jsc.add("TypeInfo " + name + "Type = new TypeInfo(" + wrapperType + ".class);");
        }
        jsc.add("// Set columns required (= not null)");
        jsc.add(name + "Type.setRequired(" + Boolean.toString(xmlNature.isRequired()) + ");");
        jsc.add("");
        jsc.add("FieldHandler " + name + "Handler;");
        jsc.add("try {");
        jsc.indent();
        String className = fInfo.getDeclaringClassInfo().getJClass().getLocalName();
        if (className != null && className.length() > 0) {
            jsc.add("Method " + name + "GetMethod = " + className + ".class.getMethod(\"get" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", null);");
            jsc.add("Method " + name + "SetMethod = " + className + ".class.getMethod(\"set" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", new Class[]{");
        }
        if (type != null && type.length() > 0) {
            jsc.addIndented(type + ".class});");
        }
        jsc.add("");
        jsc.add(name + "Handler = new FieldHandlerImpl(" + name + "FieldName, ");
        jsc.append("null, null,");
        jsc.addIndented(name + "GetMethod, " + name + "SetMethod, " + name + "Type);");
        jsc.unindent();
        jsc.add("");
        jsc.add("} catch (SecurityException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (MappingException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (NoSuchMethodException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("}");
        jsc.add("// Instantiate " + name + " field descriptor");
        jsc.add(name + "FieldDescr = new FieldDescriptorImpl(");
        jsc.append(name + "FieldName, " + name + "Type,");
        jsc.append(name + "Handler, ");
        jsc.append(Boolean.toString(fInfo.isTransient()) + ");");
        jsc.add(name + "FieldDescr.addNature(FieldDescriptorJDONature.class.getName());");
        jsc.add("FieldDescriptorJDONature " + name + "FieldJdoNature = new FieldDescriptorJDONature(" + name + "FieldDescr);");
        String sqlName = new JDOFieldInfoNature(fInfo).getColumnName();
        jsc.add(name + "FieldJdoNature.setSQLName(new String[] { \"" + sqlName + "\" });");
        jsc.add(name + "FieldJdoNature.setSQLType(new int[] {SQLTypeInfos");
        jsc.append(".javaType2sqlTypeNum(");
        if (type != null && type.length() > 0) {
            jsc.append(wrapperType + ".class) });");
        }
        jsc.add(name + "FieldJdoNature.setManyTable(null);");
        jsc.add(name + "FieldJdoNature.setManyKey(new String[] {});");
        jsc.add(name + "FieldJdoNature.setDirtyCheck(" + Boolean.toString(fNature.isDirty()) + ");");
        jsc.add(name + "FieldJdoNature.setReadOnly(" + Boolean.toString(fNature.isReadOnly()) + ");");
        jsc.add("");
        jsc.add(name + "FieldDescr.setContainingClassDescriptor(this);");
        boolean isPrimaryKey = false;
        if (cNature.getPrimaryKeys() != null) {
            isPrimaryKey = cNature.getPrimaryKeys().contains(xmlNature.getNodeName());
        }
        jsc.add(name + "FieldDescr.setIdentity(" + Boolean.toString(isPrimaryKey) + ");");
        jsc.add(name + "FM.setIdentity(" + Boolean.toString(isPrimaryKey) + ");");
        jsc.add(name + "FM.setDirect(false);");
        jsc.add(name + "FM.setName(\"" + name + "\");");
        jsc.add(name + "FM.setRequired(" + xmlNature.isRequired() + ");");
        jsc.add(name + "FM.setSetMethod(\"set" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\");");
        jsc.add(name + "FM.setGetMethod(\"get" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\");");
        jsc.add("Sql " + name + "Sql = new Sql();");
        jsc.add(name + "Sql.addName(\"" + name + "\");");
        String sqlType = fNature.getColumnType();
        if (sqlType != null && sqlType.length() > 0) {
            jsc.add(name + "Sql.setType(\"" + sqlType + "\");");
        }
        jsc.add(name + "FM.setSql(" + name + "Sql);");
        if (type != null && type.length() > 0) {
            jsc.add(name + "FM.setType(\"" + type + "\");");
        }
        jsc.add("choice.addFieldMapping(" + name + "FM);");
        return jsc;
    }

    private JSourceCode createOneToOneFieldInfoPart(FieldInfo fInfo, JSourceCode jsc) {
        JDOClassInfoNature cNature = new JDOClassInfoNature(fInfo.getDeclaringClassInfo());
        JDOOneToOneNature oneNature = new JDOOneToOneNature(fInfo);
        XMLInfoNature xmlNature = new XMLInfoNature(fInfo);
        String name = xmlNature.getNodeName();
        jsc.add("");
        jsc.add("//" + name + " field");
        jsc.add("String " + name + "FieldName = \"" + name + "\";");
        String sqlName = oneNature.getForeignKeys().get(0).toString();
        jsc.add("String " + name + "SqlName = \"" + sqlName + "\";");
        jsc.add("FieldDescriptorImpl " + name + "FieldDescr;");
        jsc.add("FieldMapping " + name + "FM = new FieldMapping();");
        String type = null;
        XSType schemaType = xmlNature.getSchemaType();
        JType javaType = schemaType.getJType();
        type = ((Object)javaType).toString();
        String wrapperType = null;
        wrapperType = javaType instanceof JPrimitiveType ? ((JPrimitiveType)javaType).getWrapperName() : type;
        if (type != null && type.length() > 0) {
            jsc.add("TypeInfo " + name + "Type = new TypeInfo(" + type + ".class);");
        }
        jsc.add("// Set columns required (= not null)");
        jsc.add(name + "Type.setRequired(" + Boolean.toString(xmlNature.isRequired()) + ");");
        jsc.add("");
        jsc.add("FieldHandler " + name + "Handler;");
        jsc.add("try {");
        jsc.indent();
        String className = fInfo.getDeclaringClassInfo().getJClass().getLocalName();
        if (className != null && className.length() > 0) {
            jsc.add("Method " + name + "GetMethod = " + className + ".class.getMethod(\"get" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", null);");
            jsc.add("Method " + name + "SetMethod = " + className + ".class.getMethod(\"set" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", new Class[]{");
        }
        if (type != null && type.length() > 0) {
            jsc.addIndented(type + ".class});");
        }
        jsc.add("");
        jsc.add(name + "Handler = new FieldHandlerImpl(" + name + "FieldName, ");
        jsc.append("null, null,");
        jsc.addIndented(name + "GetMethod, " + name + "SetMethod, " + name + "Type);");
        jsc.unindent();
        jsc.add("");
        jsc.add("} catch (SecurityException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (MappingException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (NoSuchMethodException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("}");
        jsc.add("// Instantiate " + name + " field descriptor");
        jsc.add(name + "FieldDescr = new FieldDescriptorImpl(");
        jsc.append(name + "FieldName, " + name + "Type,");
        jsc.append(name + "Handler, ");
        jsc.append(Boolean.toString(fInfo.isTransient()) + ");");
        jsc.add(name + "FieldDescr.addNature(FieldDescriptorJDONature.class.getName());");
        jsc.add("FieldDescriptorJDONature " + name + "FieldJdoNature = new FieldDescriptorJDONature(" + name + "FieldDescr);");
        jsc.add(name + "FieldJdoNature.setSQLName(new String[] { " + name + "SqlName });");
        jsc.add(name + "FieldJdoNature.setSQLType(new int[] {SQLTypeInfos");
        jsc.append(".javaType2sqlTypeNum(");
        if (type != null && type.length() > 0) {
            jsc.append(wrapperType + ".class) });");
        }
        jsc.add(name + "FieldJdoNature.setManyKey(new String[] { " + name + "SqlName });");
        jsc.add(name + "FieldJdoNature.setDirtyCheck(" + Boolean.toString(oneNature.isDirty()) + ");");
        jsc.add(name + "FieldJdoNature.setReadOnly(" + Boolean.toString(oneNature.isReadOnly()) + ");");
        jsc.add("");
        jsc.add(name + "FieldDescr.setContainingClassDescriptor(this);");
        jsc.add(name + "FieldDescr.setClassDescriptor(new " + this.getLocalName(type) + "JDODescriptor());");
        boolean isPrimaryKey = false;
        if (cNature.getPrimaryKeys() != null) {
            isPrimaryKey = cNature.getPrimaryKeys().contains(xmlNature.getNodeName());
        }
        jsc.add(name + "FM.setIdentity(" + Boolean.toString(isPrimaryKey) + ");");
        jsc.add(name + "FM.setDirect(false);");
        jsc.add(name + "FM.setName(\"" + name + "\");");
        jsc.add(name + "FM.setRequired(" + xmlNature.isRequired() + ");");
        jsc.add(name + "FM.setSetMethod(\"set" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\");");
        jsc.add(name + "FM.setGetMethod(\"get" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\");");
        jsc.add("Sql " + name + "Sql = new Sql();");
        jsc.add(name + "Sql.addName(\"" + sqlName + "\");");
        jsc.add(name + "Sql.setManyKey(new String[] {\"" + sqlName + "\"});");
        jsc.add(name + "FM.setSql(" + name + "Sql);");
        if (type != null && type.length() > 0) {
            jsc.add(name + "FM.setType(\"" + type + "\");");
        }
        jsc.add("choice.addFieldMapping(" + name + "FM);");
        return jsc;
    }

    private JSourceCode createOneToManyFieldInfoPart(FieldInfo fInfo, JSourceCode jsc) {
        JDOClassInfoNature cNature = new JDOClassInfoNature(fInfo.getDeclaringClassInfo());
        JDOOneToManyNature manyNature = new JDOOneToManyNature(fInfo);
        XMLInfoNature xmlNature = new XMLInfoNature(fInfo);
        String name = xmlNature.getNodeName();
        jsc.add("");
        jsc.add("//" + name + " field");
        jsc.add("String " + name + "FieldName = \"" + name + "\";");
        String sqlName = manyNature.getForeignKeys().get(0).toString();
        jsc.add("String " + name + "SqlName = \"" + sqlName + "\";");
        jsc.add("FieldDescriptorImpl " + name + "FieldDescr;");
        jsc.add("FieldMapping " + name + "FM = new FieldMapping();");
        String type = null;
        XSList schemaType = (XSList)xmlNature.getSchemaType();
        JType javaType = schemaType.getContentType().getJType();
        type = ((Object)javaType).toString();
        String wrapperType = null;
        wrapperType = javaType instanceof JPrimitiveType ? ((JPrimitiveType)javaType).getWrapperName() : type;
        if (type != null && type.length() > 0) {
            jsc.add("TypeInfo " + name + "Type = new TypeInfo(" + type + ".class);");
        }
        jsc.add("// Set columns required (= not null)");
        jsc.add(name + "Type.setRequired(" + Boolean.toString(xmlNature.isRequired()) + ");");
        jsc.add("");
        jsc.add("FieldHandler " + name + "Handler;");
        jsc.add("try {");
        jsc.indent();
        String className = fInfo.getDeclaringClassInfo().getJClass().getLocalName();
        if (className != null && className.length() > 0) {
            jsc.add("Method " + name + "GetMethod = " + className + ".class.getMethod(\"get" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", null);");
            jsc.add("Method " + name + "SetMethod = " + className + ".class.getMethod(\"set" + JDOClassDescriptorFactory.toUpperCaseFirstLetter(name) + "\", new Class[]{");
        }
        if (type != null && type.length() > 0) {
            jsc.addIndented(type + "[].class});");
        }
        jsc.add("");
        jsc.add(name + "Handler = new FieldHandlerImpl(" + name + "FieldName, ");
        jsc.append("null, null,");
        jsc.addIndented(name + "GetMethod, " + name + "SetMethod, " + name + "Type);");
        jsc.unindent();
        jsc.add("");
        jsc.add("} catch (SecurityException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (MappingException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("} catch (NoSuchMethodException e1) {");
        jsc.indent();
        jsc.add("throw new RuntimeException(e1.getMessage());");
        jsc.unindent();
        jsc.add("}");
        jsc.add("// Instantiate " + name + " field descriptor");
        jsc.add(name + "FieldDescr = new FieldDescriptorImpl(");
        jsc.append(name + "FieldName, " + name + "Type,");
        jsc.append(name + "Handler, ");
        jsc.append(Boolean.toString(fInfo.isTransient()) + ");");
        jsc.add(name + "FieldDescr.addNature(FieldDescriptorJDONature.class.getName());");
        jsc.add("FieldDescriptorJDONature " + name + "FieldJdoNature = new FieldDescriptorJDONature(" + name + "FieldDescr);");
        jsc.add(name + "FieldJdoNature.setSQLName(null);");
        jsc.add(name + "FieldJdoNature.setSQLType(new int[] {SQLTypeInfos");
        jsc.append(".javaType2sqlTypeNum(");
        if (type != null && type.length() > 0) {
            jsc.append(wrapperType + ".class) });");
        }
        jsc.add(name + "FieldJdoNature.setManyKey(new String[] { " + name + "SqlName });");
        jsc.add(name + "FieldJdoNature.setDirtyCheck(" + Boolean.toString(manyNature.isDirty()) + ");");
        jsc.add(name + "FieldJdoNature.setReadOnly(" + Boolean.toString(manyNature.isReadOnly()) + ");");
        jsc.add("");
        jsc.add(name + "FieldDescr.setContainingClassDescriptor(this);");
        jsc.add(name + "FieldDescr.setClassDescriptor(new " + this.getLocalName(type) + "JDODescriptor());");
        jsc.add(name + "FieldDescr.setMultivalued(true);");
        boolean isPrimaryKey = false;
        if (cNature.getPrimaryKeys() != null) {
            isPrimaryKey = cNature.getPrimaryKeys().contains(xmlNature.getNodeName());
        }
        jsc.add(name + "FM.setIdentity(" + Boolean.toString(isPrimaryKey) + ");");
        jsc.add(name + "FM.setDirect(false);");
        jsc.add(name + "FM.setName(\"" + name + "\");");
        jsc.add(name + "FM.setRequired(" + xmlNature.isRequired() + ");");
        jsc.add(name + "FM.setCollection(FieldMappingCollectionType.ARRAY);");
        jsc.add("Sql " + name + "Sql = new Sql();");
        jsc.add(name + "Sql.addName(\"" + sqlName + "\");");
        jsc.add(name + "Sql.setManyKey(new String[] {\"" + sqlName + "\"});");
        jsc.add(name + "FM.setSql(" + name + "Sql);");
        if (type != null && type.length() > 0) {
            jsc.add(name + "FM.setType(\"" + type + "\");");
        }
        jsc.add("choice.addFieldMapping(" + name + "FM);");
        return jsc;
    }

    private String getLocalName(String name) {
        return JNaming.getLocalNameFromClassName((String)name);
    }
}

