/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.core.nature.PropertyHolder;
import org.castor.core.util.Messages;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.jdo.util.JDOUtils;
import org.castor.persist.ProposedEntity;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.engine.SQLColumnInfo;
import org.exolab.castor.jdo.engine.SQLEngine;
import org.exolab.castor.jdo.engine.SQLFieldInfo;
import org.exolab.castor.jdo.engine.SQLHelper;
import org.exolab.castor.jdo.engine.nature.ClassDescriptorJDONature;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.persist.spi.QueryExpression;

public final class SQLStatementLoad {
    private static final Log LOG = LogFactory.getLog(SQLStatementLoad.class);
    private final SQLEngine _engine;
    private final PersistenceFactory _factory;
    private final String _type;
    private final String _mapTo;
    private final int _numberOfExtendLevels;
    private final Collection _extendingClassDescriptors;
    private String _statementNoLock;
    private String _statementLock;
    private QueryExpression _queryExpression;

    public SQLStatementLoad(SQLEngine engine, PersistenceFactory factory) throws MappingException {
        this._engine = engine;
        this._factory = factory;
        this._type = engine.getDescriptor().getJavaClass().getName();
        this._mapTo = new ClassDescriptorJDONature((PropertyHolder)((Object)engine.getDescriptor())).getTableName();
        this._numberOfExtendLevels = SQLHelper.numberOfExtendingClassDescriptors(engine.getDescriptor());
        this._extendingClassDescriptors = new ClassDescriptorJDONature((PropertyHolder)((Object)engine.getDescriptor())).getExtended();
        this.buildStatement();
    }

    private void buildStatement() throws MappingException {
        try {
            int i;
            QueryExpression expr = this._factory.getQueryExpression();
            HashMap<String, Boolean> identitiesUsedForTable = new HashMap<String, Boolean>();
            Vector<String> joinTables = new Vector<String>();
            ClassDescriptor curDesc = this._engine.getDescriptor();
            while (curDesc.getExtends() != null) {
                ClassDescriptor baseDesc = curDesc.getExtends();
                String[] curDescIdNames = SQLHelper.getIdentitySQLNames(curDesc);
                String[] baseDescIdNames = SQLHelper.getIdentitySQLNames(baseDesc);
                expr.addInnerJoin(new ClassDescriptorJDONature((PropertyHolder)((Object)curDesc)).getTableName(), curDescIdNames, new ClassDescriptorJDONature((PropertyHolder)((Object)baseDesc)).getTableName(), baseDescIdNames);
                joinTables.add(new ClassDescriptorJDONature((PropertyHolder)((Object)baseDesc)).getTableName());
                curDesc = baseDesc;
            }
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            SQLFieldInfo[] fields = this._engine.getInfo();
            String aliasOld = null;
            String alias = null;
            for (int i2 = 0; i2 < fields.length; ++i2) {
                int j;
                ClassDescriptor classDescriptor;
                boolean isTableNameAlreadyAdded;
                SQLFieldInfo field = fields[i2];
                if (i2 > 0) {
                    aliasOld = alias;
                }
                alias = field.getTableName();
                if (i2 == 0 && field.isJoined()) {
                    String[] identities = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    for (int j2 = 0; j2 < identities.length; ++j2) {
                        expr.addColumn(new ClassDescriptorJDONature((PropertyHolder)((Object)curDesc)).getTableName(), identities[j2]);
                    }
                    identitiesUsedForTable.put(new ClassDescriptorJDONature((PropertyHolder)((Object)curDesc)).getTableName(), Boolean.TRUE);
                }
                if (!(alias.equals(aliasOld) || field.isJoined() || (isTableNameAlreadyAdded = identitiesUsedForTable.containsKey(new ClassDescriptorJDONature((PropertyHolder)((Object)(classDescriptor = field.getFieldDescriptor().getContainingClassDescriptor()))).getTableName())))) {
                    String[] identities = SQLHelper.getIdentitySQLNames(classDescriptor);
                    for (j = 0; j < identities.length; ++j) {
                        expr.addColumn(alias, identities[j]);
                    }
                    identitiesUsedForTable.put(new ClassDescriptorJDONature((PropertyHolder)((Object)classDescriptor)).getTableName(), Boolean.TRUE);
                }
                if (field.isJoined()) {
                    int offset = 0;
                    String[] rightCol = field.getJoinFields();
                    String[] leftCol = new String[ids.length - offset];
                    for (j = 0; j < leftCol.length; ++j) {
                        leftCol[j] = ids[j + offset].getName();
                    }
                    ClassDescriptor clsDescriptor = this._engine.getDescriptor();
                    ClassDescriptorJDONature nature = new ClassDescriptorJDONature((PropertyHolder)((Object)clsDescriptor));
                    if (joinTables.contains(field.getTableName()) || nature.getTableName().equals(field.getTableName())) {
                        alias = alias.replace('.', '_') + "_f" + i2;
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol, alias);
                    } else {
                        expr.addOuterJoin(this._mapTo, leftCol, field.getTableName(), rightCol);
                        joinTables.add(field.getTableName());
                    }
                }
                for (int j3 = 0; j3 < field.getColumnInfo().length; ++j3) {
                    expr.addColumn(alias, field.getColumnInfo()[j3].getName());
                }
                expr.addTable(field.getTableName(), alias);
            }
            LinkedList classDescriptorsToAdd = new LinkedList();
            ClassDescriptor classDescriptor2 = null;
            SQLHelper.addExtendingClassDescriptors(classDescriptorsToAdd, new ClassDescriptorJDONature((PropertyHolder)((Object)this._engine.getDescriptor())).getExtended());
            if (classDescriptorsToAdd.size() > 0) {
                for (ClassDescriptor classDescriptor2 : classDescriptorsToAdd) {
                    Persistence persistenceEngine;
                    ClassDescriptorJDONature clsDescNature = new ClassDescriptorJDONature((PropertyHolder)((Object)classDescriptor2));
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Adding outer left join for " + classDescriptor2.getJavaClass().getName() + " on table " + clsDescNature.getTableName()));
                    }
                    String[] engDescIdNames = SQLHelper.getIdentitySQLNames(this._engine.getDescriptor());
                    String[] clsDescIdNames = SQLHelper.getIdentitySQLNames(classDescriptor2);
                    expr.addOuterJoin(this._mapTo, engDescIdNames, clsDescNature.getTableName(), clsDescIdNames);
                    try {
                        persistenceEngine = this._factory.getPersistence(classDescriptor2);
                    }
                    catch (MappingException e) {
                        throw new QueryException("Problem obtaining persistence engine for ClassDescriptor " + classDescriptor2.getJavaClass().getName(), e);
                    }
                    SQLEngine engine = (SQLEngine)persistenceEngine;
                    SQLColumnInfo[] idInfos = engine.getColumnInfoForIdentities();
                    for (int i3 = 0; i3 < idInfos.length; ++i3) {
                        expr.addColumn(clsDescNature.getTableName(), idInfos[i3].getName());
                    }
                    SQLFieldInfo[] fieldInfos = ((SQLEngine)persistenceEngine).getInfo();
                    for (int i4 = 0; i4 < fieldInfos.length; ++i4) {
                        boolean hasFieldToAdd = false;
                        SQLColumnInfo[] columnInfos = fieldInfos[i4].getColumnInfo();
                        if (clsDescNature.getTableName().equals(fieldInfos[i4].getTableName())) {
                            for (int j = 0; j < columnInfos.length; ++j) {
                                expr.addColumn(clsDescNature.getTableName(), fieldInfos[i4].getColumnInfo()[j].getName());
                            }
                            hasFieldToAdd = true;
                        }
                        if (!hasFieldToAdd) continue;
                        expr.addTable(clsDescNature.getTableName());
                    }
                }
            }
            QueryExpression find = (QueryExpression)expr.clone();
            for (i = 0; i < ids.length; ++i) {
                expr.addParameter(this._mapTo, ids[i].getName(), "=");
            }
            this._statementNoLock = expr.getStatement(false);
            this._statementLock = expr.getStatement(true);
            if (fields.length == 0) {
                for (i = 0; i < ids.length; ++i) {
                    find.addColumn(this._mapTo, ids[i].getName());
                }
            }
            this._queryExpression = find;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)Messages.format("jdo.loading", this._type, this._statementNoLock));
                LOG.trace((Object)Messages.format("jdo.loading.with.lock", this._type, this._statementLock));
                LOG.trace((Object)Messages.format("jdo.finding", this._type, this._queryExpression));
            }
        }
        catch (QueryException ex) {
            LOG.warn((Object)"Problem building SQL", (Throwable)ex);
            throw new MappingException(ex);
        }
    }

    public String getLoadStatement() {
        return this._statementNoLock;
    }

    public QueryExpression getQueryExpression() {
        return (QueryExpression)this._queryExpression.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeStatement(Connection conn, Identity identity, ProposedEntity entity, AccessMode accessMode) throws PersistenceException {
        ResultSet rs;
        PreparedStatement stmt;
        block26: {
            stmt = null;
            rs = null;
            SQLColumnInfo[] ids = this._engine.getColumnInfoForIdentities();
            SQLFieldInfo[] fields = this._engine.getInfo();
            try {
                try {
                    ArrayList res;
                    SQLColumnInfo[] columns;
                    SQLFieldInfo field;
                    int i;
                    boolean locked = accessMode == AccessMode.DbLocked;
                    String sqlString = locked ? this._statementLock : this._statementNoLock;
                    stmt = conn.prepareStatement(sqlString);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)Messages.format("jdo.loading", this._type, stmt.toString()));
                    }
                    int fieldIndex = 1;
                    if (identity.size() != ids.length) {
                        throw new PersistenceException("Size of identity field mismatched! expected: " + ids.length + " found: " + identity.size());
                    }
                    for (int i2 = 0; i2 < ids.length; ++i2) {
                        stmt.setObject(fieldIndex++, ids[i2].toSQL(identity.get(i2)));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.format("jdo.loading", this._type, stmt.toString()));
                    }
                    if (!(rs = stmt.executeQuery()).next()) {
                        throw new ObjectNotFoundException(Messages.format("persist.objectNotFound", this._type, identity));
                    }
                    if (this._extendingClassDescriptors.size() > 0) {
                        Object[] returnValues = SQLHelper.calculateNumberOfFields(this._extendingClassDescriptors, ids.length, fields.length, this._numberOfExtendLevels, rs);
                        ClassDescriptor potentialLeafDescriptor = (ClassDescriptor)returnValues[0];
                        if (potentialLeafDescriptor != null && !potentialLeafDescriptor.getJavaClass().getName().equals(this._type)) {
                            entity.initializeFields(potentialLeafDescriptor.getFields().length);
                            entity.setActualEntityClass(potentialLeafDescriptor.getJavaClass());
                            entity.setExpanded(true);
                        }
                        if (potentialLeafDescriptor != null) {
                            Object var23_16 = null;
                            break block26;
                        }
                    }
                    int columnIndex = ids.length + 1;
                    HashSet<String> processedTables = new HashSet<String>();
                    if (fields.length > 0 && fields[0].isJoined()) {
                        ClassDescriptor clsDesc = this._engine.getDescriptor();
                        processedTables.add(new ClassDescriptorJDONature((PropertyHolder)((Object)clsDesc)).getTableName());
                    }
                    fieldIndex = 1;
                    String tableName = null;
                    for (i = 0; i < fields.length; ++i) {
                        field = fields[i];
                        columns = field.getColumnInfo();
                        tableName = field.getTableName();
                        if (i > 0 && !field.isJoined() && !processedTables.contains(tableName)) {
                            columnIndex += ids.length;
                        }
                        processedTables.add(tableName);
                        if (!field.isJoined() && field.getJoinFields() == null) {
                            entity.setField(columns[0].toJava(SQLTypeInfos.getValue(rs, columnIndex++, columns[0].getSqlType())), i);
                            ++fieldIndex;
                            continue;
                        }
                        if (!field.isMulti()) {
                            boolean notNull = false;
                            Object[] id = new Object[columns.length];
                            for (int j = 0; j < columns.length; ++j) {
                                id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex++, columns[j].getSqlType()));
                                ++fieldIndex;
                                if (id[j] == null) continue;
                                notNull = true;
                            }
                            entity.setField(notNull ? new Identity(id) : null, i);
                            continue;
                        }
                        res = new ArrayList();
                        boolean notNull = false;
                        Object[] id = new Object[columns.length];
                        for (int j = 0; j < columns.length; ++fieldIndex, ++columnIndex, ++j) {
                            id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex, columns[j].getSqlType()));
                            if (id[j] == null) continue;
                            notNull = true;
                        }
                        if (notNull) {
                            res.add(new Identity(id));
                        }
                        entity.setField(res, i);
                    }
                    while (rs.next()) {
                        fieldIndex = 1;
                        columnIndex = ids.length + 1;
                        processedTables.clear();
                        if (fields[0].isJoined()) {
                            ClassDescriptor clsDesc = this._engine.getDescriptor();
                            processedTables.add(new ClassDescriptorJDONature((PropertyHolder)((Object)clsDesc)).getTableName());
                        }
                        for (i = 0; i < fields.length; ++i) {
                            field = fields[i];
                            columns = field.getColumnInfo();
                            tableName = field.getTableName();
                            if (i > 0 && !field.isJoined() && !processedTables.contains(tableName)) {
                                columnIndex += ids.length;
                            }
                            processedTables.add(tableName);
                            if (field.isMulti()) {
                                Identity com;
                                res = (ArrayList)entity.getField(i);
                                boolean notNull = false;
                                Object[] id = new Object[columns.length];
                                for (int j = 0; j < columns.length; ++columnIndex, ++j) {
                                    id[j] = columns[j].toJava(SQLTypeInfos.getValue(rs, columnIndex, columns[j].getSqlType()));
                                    if (id[j] == null) continue;
                                    notNull = true;
                                }
                                ++fieldIndex;
                                if (!notNull || res.contains(com = new Identity(id))) continue;
                                res.add(com);
                                continue;
                            }
                            ++fieldIndex;
                            columnIndex += columns.length;
                        }
                    }
                    Object var23_17 = null;
                }
                catch (SQLException except) {
                    LOG.fatal((Object)Messages.format("jdo.loadFatal", this._type, accessMode == AccessMode.DbLocked ? this._statementLock : this._statementNoLock), (Throwable)except);
                    throw new PersistenceException(Messages.format("persist.nested", except), except);
                }
                JDOUtils.closeResultSet(rs);
                JDOUtils.closeStatement(stmt);
                return;
            }
            catch (Throwable throwable) {
                Object var23_18 = null;
                JDOUtils.closeResultSet(rs);
                JDOUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JDOUtils.closeResultSet(rs);
        JDOUtils.closeStatement(stmt);
    }
}

