/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import org.exolab.castor.types.DateTimeBase;

public class DateTime
extends DateTimeBase {
    private static final long serialVersionUID = 6278590966410879734L;
    private static final String BAD_DATE = "Bad DateTime format: ";

    public DateTime() {
    }

    public DateTime(short[] values) {
        this.setValues(values);
    }

    public DateTime(long dateAsLong) {
        this(new Date(dateAsLong));
    }

    public DateTime(Date dateRef) {
        GregorianCalendar tempCalendar = new GregorianCalendar();
        tempCalendar.setTime(dateRef);
        this.setCentury((short)(tempCalendar.get(1) / 100));
        this.setYear((short)(tempCalendar.get(1) % 100));
        this.setMonth((short)(tempCalendar.get(2) + 1));
        this.setDay((short)tempCalendar.get(5));
        this.setHour((short)tempCalendar.get(11));
        this.setMinute((short)tempCalendar.get(12));
        this.setSecond((short)tempCalendar.get(13), (short)tempCalendar.get(14));
    }

    public DateTime(String date) throws ParseException {
        DateTime.parseDateTimeInternal(date, this);
    }

    public void setValues(short[] values) {
        if (values.length != 8) {
            throw new IllegalArgumentException("DateTime#setValues: Array length " + values.length + " != 8");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
        this.setMonth(values[2]);
        this.setDay(values[3]);
        this.setHour(values[4]);
        this.setMinute(values[5]);
        this.setSecond(values[6], values[7]);
    }

    public short[] getValues() {
        short[] result = new short[]{this.getCentury(), this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli()};
        return result;
    }

    public Date toDate() {
        GregorianCalendar calendar = new GregorianCalendar(this.getCentury() * 100 + this.getYear(), this.getMonth() - 1, this.getDay(), this.getHour(), this.getMinute(), this.getSeconds());
        calendar.set(14, this.getMilli());
        this.setDateFormatTimeZone(calendar);
        return calendar.getTime();
    }

    public long toLong() {
        return this.toDate().getTime();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.appendDateString(result);
        result.append('T');
        this.appendTimeString(result);
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static DateTime parse(String str) throws ParseException {
        return DateTime.parseDateTime(str);
    }

    public static DateTime parseDateTime(String str) throws ParseException {
        return DateTime.parseDateTimeInternal(str, new DateTime());
    }

    private static DateTime parseDateTimeInternal(String str, DateTime result) throws ParseException {
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new DateTime();
        }
        if ((chars = str.toCharArray()).length < 19) {
            throw new ParseException(BAD_DATE + str + "\nDateTime is not long enough", 0);
        }
        int idx = 0;
        idx = DateTime.parseYear((String)str, (DateTimeBase)result, (char[])chars, (int)idx, (String)BAD_DATE);
        idx = DateTime.parseMonth((String)str, (DateTimeBase)result, (char[])chars, (int)idx, (String)BAD_DATE);
        if (chars[idx = DateTime.parseDay((String)str, (DateTimeBase)result, (char[])chars, (int)idx, (String)BAD_DATE)] != 'T') {
            throw new ParseException(BAD_DATE + str + "\n 'T' " + " is wrongly placed.", idx);
        }
        ++idx;
        idx = DateTime.parseTime((String)str, (DateTimeBase)result, (char[])chars, (int)idx, (String)BAD_DATE);
        DateTime.parseTimeZone((String)str, (DateTimeBase)result, (char[])chars, (int)idx, (String)BAD_DATE);
        return result;
    }
}

