/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class SqlBindParser {
    private String _sql;
    private int _pos;
    private int _lastPos;
    private int _bindPos;

    public SqlBindParser(String sql) {
        this._sql = sql;
        this._pos = 0;
        this._lastPos = 0;
        this._bindPos = 0;
    }

    public boolean next() {
        this._lastPos = this._pos;
        int idxStart = this._sql.indexOf(63, this._pos);
        if (idxStart == -1) {
            this._bindPos = this._pos = this._sql.length();
            return false;
        }
        this._bindPos = idxStart;
        int idxEnd = idxStart;
        while (++idxEnd < this._sql.length() && Character.isDigit(this._sql.charAt(idxEnd))) {
        }
        this._pos = idxEnd;
        return true;
    }

    public String getLastExpr() {
        return this._sql.substring(this._lastPos, this._bindPos);
    }

    public String getBindExpr() {
        return this._sql.substring(this._bindPos, this._pos);
    }

    public int getParamNumber() {
        int idx = this._bindPos + 1;
        if (idx < this._pos) {
            return Integer.parseInt(this._sql.substring(idx, this._pos));
        }
        return 0;
    }

    public static String getJdbcSql(String pre_sql) {
        StringBuffer sb = new StringBuffer();
        SqlBindParser parser = new SqlBindParser(pre_sql);
        while (parser.next()) {
            sb.append(parser.getLastExpr());
            sb.append("?");
        }
        sb.append(parser.getLastExpr());
        return sb.toString();
    }

    public static void bindJdbcValues(PreparedStatement stmt, String pre_sql, Object[] values) throws SQLException {
        SqlBindParser parser = new SqlBindParser(pre_sql);
        int i = 1;
        while (parser.next()) {
            int bindNum = parser.getParamNumber();
            if (bindNum == 0) {
                bindNum = i;
            }
            stmt.setObject(i, values[bindNum - 1]);
            ++i;
        }
    }
}

