/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.xml.util.BaseResolutionCommand;
import org.exolab.castor.xml.util.ClassLoaderNature;
import org.exolab.castor.xml.util.PackageBasedCDRResolutionNature;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

public class ClassResolutionByCDR
extends BaseResolutionCommand {
    private static final Log LOG = LogFactory.getLog(ClassResolutionByCDR.class);

    public ClassResolutionByCDR() {
        this.addNature(ClassLoaderNature.class.getName());
        this.addNature(PackageBasedCDRResolutionNature.class.getName());
    }

    public ClassDescriptor resolve(Class type) {
        List packages = new PackageBasedCDRResolutionNature(this).getPackageNames();
        if (packages == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No package names to search descriptors in were passed. No descriptors will be loaded!");
            }
            return null;
        }
        String typeName = type.getName();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Map descriptors = this.getDescriptors((String)it.next());
            if (!descriptors.containsKey(typeName)) continue;
            return (ClassDescriptor)descriptors.get(typeName);
        }
        return null;
    }

    private Properties getProperties(URL url) throws IOException {
        Properties properties = new Properties();
        InputStream stream = url.openStream();
        properties.load(stream);
        stream.close();
        return properties;
    }

    public Map getDescriptors(String packageName) {
        HashMap<String, ClassDescriptor> descriptors = new HashMap<String, ClassDescriptor>();
        ClassLoader loader = new ClassLoaderNature(this).getClassLoader();
        URL cdrUrl = loader.getResource(ResolveHelpers.getQualifiedFileName(".castor.jdo.cdr", packageName));
        Properties cdrList = new Properties();
        try {
            cdrList = this.getProperties(cdrUrl);
            Enumeration<Object> classes = cdrList.keys();
            while (classes.hasMoreElements()) {
                String className = (String)classes.nextElement();
                String classDescriptorName = cdrList.getProperty(className);
                Class classDescriptor = ResolveHelpers.loadClass(loader, classDescriptorName);
                if (classDescriptor == null) continue;
                ClassDescriptor descriptorInstance = (ClassDescriptor)classDescriptor.newInstance();
                descriptors.put(className, descriptorInstance);
            }
        }
        catch (Exception e) {
            String message = "Failure occured while loading classes from packacge \"" + packageName + "\" with exception: " + e;
            LOG.warn((Object)message);
            throw new RuntimeException(e.getMessage());
        }
        return descriptors;
    }
}

