/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JAnnotationTypeElement
implements JMember {
    private String _name;
    private JDocComment _comment;
    private JType _type;
    private JModifiers _modifiers;
    private String _default;

    public JAnnotationTypeElement(String name, JType type) {
        this.setName(name);
        this._type = type;
        this._modifiers = new JModifiers();
        this._comment = new JDocComment();
        this._comment.appendComment("Element " + name);
    }

    public JModifiers getModifiers() {
        return this._modifiers;
    }

    public void setName(String name) {
        if (!JNaming.isValidJavaIdentifier(name)) {
            String err = "'" + name + "' is ";
            err = JNaming.isKeyword(name) ? err + "a reserved word and may not be used as  a field name." : err + "not a valid Java identifier.";
            throw new IllegalArgumentException(err);
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public JType getType() {
        return this._type;
    }

    public String getDefaultString() {
        return this._default;
    }

    public void setDefaultString(String defaultString) {
        this._default = defaultString;
    }

    public void setComment(JDocComment comment) {
        this._comment = comment;
    }

    public void setComment(String comment) {
        if (this._comment == null) {
            this._comment = new JDocComment();
        }
        this._comment.setComment(comment);
    }

    public JDocComment getComment() {
        return this._comment;
    }

    public void print(JSourceWriter jsw) {
        if (this._comment != null) {
            this._comment.print(jsw);
        }
        jsw.write(((Object)this._type).toString());
        jsw.write(" ");
        jsw.write(this._name);
        jsw.write("()");
        if (this._default != null) {
            jsw.write(" default ");
            jsw.write(this._default);
        }
        jsw.write(";");
    }
}

