/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JEnumConstant;
import org.exolab.javasource.JField;
import org.exolab.javasource.JMember;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JSourceWriter;

public final class JEnum
extends JClass {
    private JNamedMap _constants = new JNamedMap();

    public JEnum(String name) {
        super(name);
        this.getJDocComment().setComment("Enumeration " + this.getLocalName() + ".");
    }

    public void addConstructor(JConstructor constructor) {
        if (constructor.getModifiers().isPrivate()) {
            super.addConstructor(constructor);
        }
    }

    public void addMember(JMember jMember) {
        if (jMember instanceof JEnumConstant) {
            this.addConstant((JEnumConstant)jMember);
        } else if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else if (jMember instanceof JMethod) {
            this.addMethod((JMethod)jMember);
        } else {
            String error = null;
            error = jMember == null ? "the argument 'jMember' must not be null." : "Cannot add JMember '" + jMember.getClass().getName() + "' to JClass, unrecognized type.";
            throw new IllegalArgumentException(error);
        }
    }

    public void addConstant(JEnumConstant jConstant) {
        if (jConstant == null) {
            throw new IllegalArgumentException("Enum fields cannot be null");
        }
        String name = jConstant.getName();
        if (this._constants.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._constants.put(name, jConstant);
    }

    public JEnumConstant getConstant(String name) {
        return (JEnumConstant)this._constants.get(name);
    }

    public JEnumConstant[] getConstants() {
        int size = this._constants.size();
        JEnumConstant[] farray = new JEnumConstant[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JEnumConstant)this._constants.get(i);
        }
        return farray;
    }

    public int getConstantCount() {
        return this._constants.size();
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        if (!classOnly) {
            this.printClassHeaders(jsw);
        }
        this.getJDocComment().print(jsw);
        this.printEnumDefinitionLine(jsw);
        jsw.writeln();
        jsw.indent();
        this.printEnumConstants(jsw);
        this.printMemberVariables(jsw);
        this.printStaticInitializers(jsw);
        this.printConstructors(jsw);
        this.printMethods(jsw);
        this.printInnerClasses(jsw);
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    private void printEnumDefinitionLine(JSourceWriter jsw) {
        StringBuilder buffer = new StringBuilder();
        this.getAnnotatedElementHelper().printAnnotations(jsw);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        buffer.append("enum ");
        buffer.append(this.getLocalName());
        buffer.append(' ');
        if (this.getInterfaceCount() > 0) {
            boolean endl = false;
            if (this.getInterfaceCount() > 1) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
                endl = true;
            }
            buffer.append("implements ");
            Enumeration enumeration = this.getInterfaces();
            while (enumeration.hasMoreElements()) {
                buffer.append((String)enumeration.nextElement());
                if (!enumeration.hasMoreElements()) continue;
                buffer.append(", ");
            }
            if (endl) {
                jsw.writeln(buffer.toString());
                buffer.setLength(0);
            } else {
                buffer.append(' ');
            }
        }
        buffer.append('{');
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
    }

    private void printEnumConstants(JSourceWriter jsw) {
        if (this._constants.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //------------------/");
            jsw.writeln(" //- Enum Constants -/");
            jsw.writeln("//------------------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._constants.size(); ++i) {
            JEnumConstant jConstant = (JEnumConstant)this._constants.get(i);
            jConstant.print(jsw);
            if (i < this._constants.size() - 1) {
                jsw.write(",");
            } else {
                jsw.write(";");
            }
            jsw.writeln();
        }
    }
}

