/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractPartial
implements ReadablePartial,
Comparable {
    protected AbstractPartial() {
    }

    protected abstract DateTimeField getField(int var1, Chronology var2);

    public DateTimeFieldType getFieldType(int index) {
        return this.getField(index, this.getChronology()).getType();
    }

    public DateTimeFieldType[] getFieldTypes() {
        DateTimeFieldType[] result = new DateTimeFieldType[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getFieldType(i);
            ++i;
        }
        return result;
    }

    public DateTimeField getField(int index) {
        return this.getField(index, this.getChronology());
    }

    public DateTimeField[] getFields() {
        DateTimeField[] result = new DateTimeField[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getField(i);
            ++i;
        }
        return result;
    }

    public int[] getValues() {
        int[] result = new int[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getValue(i);
            ++i;
        }
        return result;
    }

    public int get(DateTimeFieldType type) {
        return this.getValue(this.indexOfSupported(type));
    }

    public boolean isSupported(DateTimeFieldType type) {
        return this.indexOf(type) != -1;
    }

    public int indexOf(DateTimeFieldType type) {
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.getFieldType(i) == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int indexOfSupported(DateTimeFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            throw new IllegalArgumentException("Field '" + type + "' is not supported");
        }
        return index;
    }

    protected int indexOf(DurationFieldType type) {
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.getFieldType(i).getDurationType() == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int indexOfSupported(DurationFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            throw new IllegalArgumentException("Field '" + type + "' is not supported");
        }
        return index;
    }

    public DateTime toDateTime(ReadableInstant baseInstant) {
        Chronology chrono = DateTimeUtils.getInstantChronology(baseInstant);
        long instantMillis = DateTimeUtils.getInstantMillis(baseInstant);
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    public boolean equals(Object partial) {
        if (this == partial) {
            return true;
        }
        if (!(partial instanceof ReadablePartial)) {
            return false;
        }
        ReadablePartial other = (ReadablePartial)partial;
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.getValue(i) != other.getValue(i) || this.getFieldType(i) != other.getFieldType(i)) {
                return false;
            }
            ++i;
        }
        return this.getChronology() == other.getChronology();
    }

    public int hashCode() {
        int total = 157;
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            total = 23 * total + this.getValue(i);
            total = 23 * total + this.getFieldType(i).hashCode();
            ++i;
        }
        return total += this.getChronology().hashCode();
    }

    public int compareTo(Object partial) {
        if (this == partial) {
            return 0;
        }
        ReadablePartial other = (ReadablePartial)partial;
        if (this.size() != other.size()) {
            throw new ClassCastException("ReadablePartial objects must have matching field types");
        }
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.getFieldType(i) != other.getFieldType(i)) {
                throw new ClassCastException("ReadablePartial objects must have matching field types");
            }
            ++i;
        }
        int i2 = 0;
        int isize2 = this.size();
        while (i2 < isize2) {
            if (this.getValue(i2) > other.getValue(i2)) {
                return 1;
            }
            if (this.getValue(i2) < other.getValue(i2)) {
                return -1;
            }
            ++i2;
        }
        return 0;
    }

    public boolean isAfter(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) > 0;
    }

    public boolean isBefore(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) < 0;
    }

    public boolean isEqual(ReadablePartial partial) {
        if (partial == null) {
            throw new IllegalArgumentException("Partial cannot be null");
        }
        return this.compareTo(partial) == 0;
    }

    public String toString(DateTimeFormatter formatter) {
        if (formatter == null) {
            return this.toString();
        }
        return formatter.print(this);
    }

    public abstract Chronology getChronology();

    public abstract int getValue(int var1);

    public abstract int size();
}

