/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;

public abstract class AbstractPeriod
implements ReadablePeriod {
    protected AbstractPeriod() {
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] result = new DurationFieldType[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getFieldType(i);
            ++i;
        }
        return result;
    }

    public int[] getValues() {
        int[] result = new int[this.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getValue(i);
            ++i;
        }
        return result;
    }

    public int get(DurationFieldType type) {
        int index = this.indexOf(type);
        if (index == -1) {
            return 0;
        }
        return this.getValue(index);
    }

    public boolean isSupported(DurationFieldType type) {
        return this.getPeriodType().isSupported(type);
    }

    public int indexOf(DurationFieldType type) {
        return this.getPeriodType().indexOf(type);
    }

    public Period toPeriod() {
        return new Period(this);
    }

    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    public boolean equals(Object period) {
        if (this == period) {
            return true;
        }
        if (!(period instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod other = (ReadablePeriod)period;
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.getValue(i) != other.getValue(i) || this.getFieldType(i) != other.getFieldType(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int total = 17;
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            total = 27 * total + this.getValue(i);
            total = 27 * total + this.getFieldType(i).hashCode();
            ++i;
        }
        return total;
    }

    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public abstract int getValue(int var1);

    public abstract DurationFieldType getFieldType(int var1);

    public abstract int size();

    public abstract PeriodType getPeriodType();
}

