/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.ImpreciseDateTimeField;

final class BasicWeekyearDateTimeField
extends ImpreciseDateTimeField {
    private static final long serialVersionUID = 6215066916806820644L;
    private static final long WEEK_53 = 31449600000L;
    private final BaseGJChronology iChronology;

    BasicWeekyearDateTimeField(BaseGJChronology chronology) {
        super(DateTimeFieldType.weekyear(), chronology.getAverageMillisPerYear());
        this.iChronology = chronology;
    }

    public boolean isLenient() {
        return false;
    }

    public int get(long instant) {
        return this.iChronology.getWeekyear(instant);
    }

    public long add(long instant, int years) {
        if (years == 0) {
            return instant;
        }
        return this.set(instant, this.get(instant) + years);
    }

    public long add(long instant, long value) {
        return this.add(instant, FieldUtils.safeToInt(value));
    }

    public long addWrapField(long instant, int years) {
        return this.add(instant, years);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        if (minuendInstant < subtrahendInstant) {
            return -this.getDifference(subtrahendInstant, minuendInstant);
        }
        int minuendWeekyear = this.get(minuendInstant);
        int subtrahendWeekyear = this.get(subtrahendInstant);
        long minuendRem = this.remainder(minuendInstant);
        long subtrahendRem = this.remainder(subtrahendInstant);
        if (subtrahendRem >= 31449600000L && this.iChronology.getWeeksInYear(minuendWeekyear) <= 52) {
            subtrahendRem -= 604800000L;
        }
        int difference = minuendWeekyear - subtrahendWeekyear;
        if (minuendRem < subtrahendRem) {
            --difference;
        }
        return difference;
    }

    public long set(long instant, int year) {
        FieldUtils.verifyValueBounds(this, Math.abs(year), this.iChronology.getMinYear(), this.iChronology.getMaxYear());
        int thisWeekyear = this.get(instant);
        if (thisWeekyear == year) {
            return instant;
        }
        int thisDow = this.iChronology.getDayOfWeek(instant);
        int weeksInFromYear = this.iChronology.getWeeksInYear(thisWeekyear);
        int weeksInToYear = this.iChronology.getWeeksInYear(year);
        int maxOutWeeks = weeksInToYear < weeksInFromYear ? weeksInToYear : weeksInFromYear;
        int setToWeek = this.iChronology.getWeekOfWeekyear(instant);
        if (setToWeek > maxOutWeeks) {
            setToWeek = maxOutWeeks;
        }
        long workInstant = instant;
        int workWoyYear = this.get(workInstant = this.iChronology.setYear(workInstant, year));
        if (workWoyYear < year) {
            workInstant += 604800000L;
        } else if (workWoyYear > year) {
            workInstant -= 604800000L;
        }
        int currentWoyWeek = this.iChronology.getWeekOfWeekyear(workInstant);
        workInstant += (long)(setToWeek - currentWoyWeek) * 604800000L;
        workInstant = this.iChronology.dayOfWeek().set(workInstant, thisDow);
        return workInstant;
    }

    public DurationField getRangeDurationField() {
        return null;
    }

    public boolean isLeap(long instant) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(instant)) > 52;
    }

    public int getLeapAmount(long instant) {
        return this.iChronology.getWeeksInYear(this.iChronology.getWeekyear(instant)) - 52;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.weeks();
    }

    public int getMinimumValue() {
        return this.iChronology.getMinYear();
    }

    public int getMaximumValue() {
        return this.iChronology.getMaxYear();
    }

    public long roundFloor(long instant) {
        instant = this.iChronology.weekOfWeekyear().roundFloor(instant);
        int wow = this.iChronology.getWeekOfWeekyear(instant);
        if (wow > 1) {
            instant -= 604800000L * (long)(wow - 1);
        }
        return instant;
    }

    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    private Object readResolve() {
        return this.iChronology.weekyear();
    }
}

