/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class CopticMonthOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = 7741038885247700323L;
    private final BaseGJChronology iChronology;

    CopticMonthOfYearDateTimeField(BaseGJChronology chronology, DurationField months) {
        super(DateTimeFieldType.monthOfYear(), months);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return (this.iChronology.getDayOfYear(instant) - 1) / 30 + 1;
    }

    public long set(long instant, int value) {
        int day;
        instant = super.set(instant, value);
        if (value == 13 && (day = this.iChronology.getDayOfYear(instant)) < 30) {
            instant -= 86400000L * (long)day;
        }
        return instant;
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public boolean isLeap(long instant) {
        return this.get(instant) > 12 && this.iChronology.isLeapYear(this.iChronology.getYear(instant));
    }

    public int getLeapAmount(long instant) {
        return this.isLeap(instant) ? 1 : 0;
    }

    public DurationField getLeapDurationField() {
        return this.iChronology.days();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 13;
    }

    private Object readResolve() {
        return this.iChronology.monthOfYear();
    }
}

