/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.BuddhistChronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.PartialConverter;

final class CalendarConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter {
    static final CalendarConverter INSTANCE = new CalendarConverter();
    static /* synthetic */ Class class$java$util$Calendar;

    protected CalendarConverter() {
    }

    public Chronology getChronology(Object object, Chronology chrono) {
        if (chrono != null) {
            return chrono;
        }
        Calendar cal = (Calendar)object;
        DateTimeZone zone = null;
        try {
            zone = DateTimeZone.forTimeZone(cal.getTimeZone());
        }
        catch (IllegalArgumentException ex) {
            zone = DateTimeZone.getDefault();
        }
        return this.getChronology((Object)cal, zone);
    }

    public Chronology getChronology(Object object, DateTimeZone zone) {
        if (object.getClass().getName().endsWith(".BuddhistCalendar")) {
            return BuddhistChronology.getInstance(zone);
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gc = (GregorianCalendar)object;
            long cutover = gc.getGregorianChange().getTime();
            if (cutover == Long.MIN_VALUE) {
                return Chronology.getGregorian(zone);
            }
            if (cutover == Long.MAX_VALUE) {
                return Chronology.getJulian(zone);
            }
            return GJChronology.getInstance(zone, cutover, 4);
        }
        return Chronology.getISO(zone);
    }

    public long getInstantMillis(Object object, Chronology chrono) {
        return ((Calendar)object).getTime().getTime();
    }

    public Class getSupportedType() {
        return class$java$util$Calendar == null ? (class$java$util$Calendar = CalendarConverter.class$("java.util.Calendar")) : class$java$util$Calendar;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

