/*
 * Decompiled with CFR 0.152.
 */
package slag.editor;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import slag.editor.SLAGSaveListner;
import slag.editor.controllers.QuizController;
import slag.editor.views.QuizView;

public class SLAGEditor
extends JFrame {
    private QuizView mQuizView = new QuizView();
    private QuizController mQuizController;
    private JButton mSave = new JButton();
    private JButton mCancel = new JButton();
    private JButton mApply = new JButton();
    private String mContentPath;
    private SLAGSaveListner mSaveListner;
    private String mSaveLocation;

    public SLAGEditor(String contentPath, String saveLocatoin) {
        this.Initialize(null, "");
        this.setTitle("SLAG Quiz Editor");
        this.mContentPath = contentPath;
        this.mSaveLocation = saveLocatoin;
        this.setSize(new Dimension(800, 600));
    }

    public void addSaveListner(SLAGSaveListner listner) {
        this.mSaveListner = listner;
    }

    public SLAGEditor(String path, String contentPath, String saveLocatoin) {
        this.mContentPath = contentPath;
        this.mSaveLocation = saveLocatoin;
        this.setTitle("SLAG Quiz Editor");
        File file = new File(path);
        if (file.exists()) {
            SAXBuilder builder = new SAXBuilder();
            try {
                Document doc = builder.build(new File(path));
                this.Initialize(doc, file.getParent());
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void copyDirectory(String source, String dest) throws IOException {
        this.copyDirectory(new File(source), new File(dest));
    }

    private void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            File[] files = sourceLocation.listFiles();
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void Initialize(Document quiz, String rootDirectory) {
        this.setSize(new Dimension(800, 600));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        Container comp = this.getContentPane();
        this.mQuizView.setSize(100, 100);
        mainPanel.add(this.mQuizView);
        JPanel buttonPanel = new JPanel();
        this.mSave.setText("Save");
        this.mCancel.setText("Cancel");
        buttonPanel.add(this.mSave);
        buttonPanel.add(this.mApply);
        buttonPanel.add(this.mCancel);
        this.mApply.setText("Apply");
        this.mApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SLAGEditor.this.mQuizController.Save();
            }
        });
        this.mQuizController = new QuizController(quiz, this.mQuizView);
        try {
            this.mQuizController.Load(rootDirectory);
        }
        catch (JDOMException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.mCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SLAGEditor.this.setVisible(false);
            }
        });
        this.mSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File output = new File(SLAGEditor.this.mSaveLocation);
                boolean didItExport = false;
                if (output.isDirectory()) {
                    String destPath = null;
                    try {
                        if (SLAGEditor.this.mQuizController.Save()) {
                            destPath = new File(output, SLAGEditor.this.mQuizView.getQuizTitle()).getCanonicalPath();
                            SLAGEditor.this.copyDirectory(SLAGEditor.this.mContentPath, destPath);
                            SLAGEditor.this.mQuizController.Export(destPath);
                            didItExport = true;
                        }
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    if (SLAGEditor.this.mSaveListner != null && didItExport) {
                        String title = SLAGEditor.this.mQuizView.getQuizTitle();
                        SLAGEditor.this.mSaveListner.saveFinished(this, destPath, title);
                    }
                }
                if (didItExport) {
                    SLAGEditor.this.setVisible(false);
                }
            }
        });
        mainPanel.add(buttonPanel);
        comp.add(mainPanel);
    }
}

