/*
 * Decompiled with CFR 0.152.
 */
package slag.editor.controllers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import slag.editor.controllers.AnswerController;
import slag.editor.interfaces.AnswerViewInterface;
import slag.editor.interfaces.QuestionViewInterface;
import slag.editor.models.Answer;
import slag.editor.models.Question;

public class QuestionController {
    private static final String Q_TEXT = "q_text";
    private static final String TYPE = "type";
    private static final String QID = "qid";
    private static final String QUESTION = "question";
    private static final String QUESTIONPOOL = "questionpool";

    public Question Save(QuestionViewInterface view) {
        if (view.getText() != null && !view.getText().isEmpty()) {
            view.setTextError(true);
            view.setIsAnswerSelected(true);
            Question question = new Question(view.getText(), view.getQuestionType());
            AnswerController controller = new AnswerController();
            boolean answerSelected = false;
            for (AnswerViewInterface answerView : view.getAnswerViews()) {
                answerSelected |= answerView.getIsAnswer();
                question.addAnswer(controller.Save(answerView));
            }
            if (answerSelected || view.getQuestionType().equals("other")) {
                return question;
            }
            view.setIsAnswerSelected(false);
            return null;
        }
        view.setTextError(false);
        return null;
    }

    public Question Load(String doc) throws JDOMException, IOException {
        return this.Load(new File(doc));
    }

    public Question Load(File doc) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(doc);
        return this.Load(document);
    }

    public Question Load(Document doc) {
        Element root = doc.getRootElement().getChild(QUESTION);
        Element qText = root.getChild(Q_TEXT);
        Question question = new Question(qText.getText(), root.getAttribute(TYPE).getValue());
        AnswerController controller = new AnswerController();
        for (Object obj : root.getChildren("answer")) {
            Element element = (Element)obj;
            question.addAnswer(controller.Load(element));
        }
        return question;
    }

    public String Export(String saveLocation, int questionNumber, Question question) throws IOException {
        File dir = new File(saveLocation);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("saveLocation has to be a valid directory");
        }
        Document doc = this.createDom(question, questionNumber);
        return this.writeFile(questionNumber, dir, doc);
    }

    private Document createDom(Question question, int questionNumber) {
        Document doc = new Document();
        Element questionRoot = new Element(QUESTIONPOOL);
        Element questionElement = new Element(QUESTION);
        Attribute qid = new Attribute(QID, String.format("urn:%s", questionNumber));
        questionElement.setAttribute(qid);
        questionElement.setAttribute(new Attribute(TYPE, question.getQuestionType()));
        questionRoot.addContent(questionElement);
        Element qText = new Element(Q_TEXT);
        qText.setText(question.getText());
        questionElement.addContent(qText);
        AnswerController controller = new AnswerController();
        for (Answer ac : question.getAnswers()) {
            questionElement.addContent(controller.Export(ac));
        }
        doc.setRootElement(questionRoot);
        return doc;
    }

    private String writeFile(int questionNumber, File dir, Document doc) throws FileNotFoundException, IOException {
        File output = new File(dir, String.format("question%s.xml", questionNumber));
        output.createNewFile();
        XMLOutputter outputter = new XMLOutputter();
        FileOutputStream stream = new FileOutputStream(output);
        outputter.output(doc, (OutputStream)stream);
        stream.close();
        return output.getCanonicalPath();
    }
}

