/*
 * Decompiled with CFR 0.152.
 */
package slag.editor.controllers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import slag.editor.controllers.QuestionController;
import slag.editor.interfaces.AnswerViewInterface;
import slag.editor.interfaces.QuestionViewInterface;
import slag.editor.interfaces.QuizViewInterface;
import slag.editor.models.Answer;
import slag.editor.models.Question;
import slag.editor.models.Quiz;

public class QuizController {
    private static final String QUIZ = "Quiz";
    private static final String QUESTION_ID = "question_id";
    private static final String QUESTIONS = "questions";
    private static final String TITLE = "title";
    private static final String DRAW_SIZE = "draw_size";
    private static final String QUESTION_BANK = "question_bank";
    private static final String URL = "url";
    private static final String QUESTIONREF = "questionref";
    private static final String RANDOMIZE_QUESTIONS = "randomize_questions";
    private static final String RANDOMIZE_ANSWERS = "randomize_answers";
    private static final String QUIZ_DESCRIPTION = "quiz_description";
    private static final String QUIZ_TITLE = "quiz_title";
    private static final String QUIZ_WITH_BANKS = "quiz_with_banks";
    private static final String QUIZ_PROPERTIES = "quiz_properties";
    private Quiz mQuiz;
    private QuizViewInterface mView;
    private Document mDocument;

    public QuizController(Document quiz, QuizViewInterface view) {
        this.mDocument = quiz;
        this.mView = view;
    }

    public void Load(String rootDirectory) throws JDOMException, IOException {
        this.mQuiz = this.mDocument == null ? new Quiz() : this.createQuizFromXML(this.mDocument, rootDirectory);
        this.populateView();
    }

    private Quiz createQuizFromXML(Document quizDocument, String rootPath) throws JDOMException, IOException {
        Quiz quiz = new Quiz();
        Element root = quizDocument.getRootElement();
        Element quizProperties = root.getChild(QUIZ_PROPERTIES);
        Attribute randomQuestions = quizProperties.getAttribute(RANDOMIZE_QUESTIONS);
        Attribute randomAnswers = quizProperties.getAttribute(RANDOMIZE_ANSWERS);
        Element quizTitle = root.getChild(QUIZ_TITLE);
        Element quizDescription = root.getChild(QUIZ_DESCRIPTION);
        quiz.setRandomizeAnswers(randomAnswers.getValue().equals("t"));
        quiz.setRandomizeQuestions(randomQuestions.getValue().equals("t"));
        quiz.setQuizDescription(quizDescription.getText());
        quiz.setQuizTitle(quizTitle.getText());
        QuestionController controller = new QuestionController();
        for (Object obj : root.getChildren(QUESTIONREF)) {
            Element questionRef = (Element)obj;
            Element url = questionRef.getChild(URL);
            quiz.addQuestion(controller.Load(new File(rootPath, url.getText()).getCanonicalFile()));
        }
        return quiz;
    }

    private void populateView() {
        this.mView.setQuizDescription(this.mQuiz.getQuizDescription());
        this.mView.setQuizTitle(this.mQuiz.getQuizTitle());
        this.mView.setRandomizeAnswers(this.mQuiz.isRandomizeAnswers());
        this.mView.setRandomizeQuestions(this.mQuiz.isRandomizeQuestions());
        this.mView.getQuestionViews().clear();
        for (Question question : this.mQuiz.getQuestions()) {
            QuestionViewInterface questionView = this.mView.createQuestionView();
            questionView.setQuestionType(question.getQuestionType());
            questionView.setText(question.getText());
            questionView.clearAnswers();
            for (Answer ans : question.getAnswers()) {
                AnswerViewInterface answerView = questionView.createAnswerView();
                answerView.setAnswerText(ans.getAnswer());
                answerView.setIsAnswer(ans.isCorrectAnswer());
            }
        }
        this.mView.update();
    }

    public boolean Save() {
        String title;
        if (this.mQuiz == null) {
            this.mQuiz = new Quiz();
        }
        if ((title = this.mView.getQuizTitle()) == null || title.isEmpty()) {
            this.mView.setQuizTitleError(false);
            return false;
        }
        this.mView.setQuizTitleError(true);
        this.mQuiz.setQuizDescription(this.mView.getQuizDescription());
        this.mQuiz.setQuizTitle(this.mView.getQuizTitle());
        this.mQuiz.setRandomizeAnswers(this.mView.getRandomizeAnswers());
        this.mQuiz.setRandomizeQuestions(this.mView.getRandomizeQuestions());
        this.mQuiz.clearQuestions();
        QuestionController controller = new QuestionController();
        for (QuestionViewInterface question : this.mView.getQuestionViews()) {
            Question q = controller.Save(question);
            if (q != null) {
                this.mQuiz.addQuestion(q);
                continue;
            }
            return false;
        }
        return true;
    }

    public String Export(String saveLocation) throws FileNotFoundException, IOException {
        File dir = new File(saveLocation);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("saveLocation has to be a valid directory");
        }
        Element root = new Element(QUIZ_WITH_BANKS);
        this.generateDOM(dir, root);
        Document doc = new Document(root);
        return this.writeFile("quiz.xml", dir, doc);
    }

    private void generateDOM(File dir, Element root) {
        Element quizProperties = new Element(QUIZ_PROPERTIES);
        Attribute randomAnswers = new Attribute(RANDOMIZE_ANSWERS, this.mQuiz.isRandomizeAnswers() ? "t" : "f");
        Attribute randomQuestion = new Attribute(RANDOMIZE_QUESTIONS, this.mQuiz.isRandomizeQuestions() ? "t" : "f");
        quizProperties.setAttribute(randomAnswers);
        quizProperties.setAttribute(randomQuestion);
        Element quizTitle = new Element(QUIZ_TITLE);
        quizTitle.setText(this.mQuiz.getQuizTitle());
        Element quizDescription = new Element(QUIZ_DESCRIPTION);
        quizDescription.setText(this.mQuiz.getQuizDescription());
        root.addContent(quizProperties);
        root.addContent(quizTitle);
        root.addContent(quizDescription);
        Element quizBank = new Element(QUESTION_BANK);
        quizBank.setAttribute(new Attribute(RANDOMIZE_QUESTIONS, this.mQuiz.isRandomizeQuestions() ? "t" : "f"));
        quizBank.setAttribute(new Attribute(DRAW_SIZE, Integer.toString(this.mQuiz.getQuestions().length)));
        Element quizBankTitle = new Element(TITLE);
        quizBankTitle.setText(QUIZ);
        quizBank.addContent(quizBankTitle);
        this.processQuestions(root, quizBank, dir);
        root.addContent(quizBank);
    }

    private void processQuestions(Element root, Element quizBank, File dir) {
        QuestionController controller = new QuestionController();
        File location = new File(dir, QUESTIONS);
        if (!location.exists()) {
            location.mkdir();
        }
        int i = 1;
        for (Question question : this.mQuiz.getQuestions()) {
            try {
                String questionFile = controller.Export(location.getCanonicalPath(), i, question);
                int start = questionFile.lastIndexOf("questions\\");
                questionFile = questionFile.substring(start);
                root.addContent(this.createQuestionRef(questionFile));
                Element questionId = new Element(QUESTION_ID);
                questionId.setText(String.format("urn:%s", i));
                quizBank.addContent(questionId);
                ++i;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String writeFile(String quizFileName, File dir, Document doc) throws FileNotFoundException, IOException {
        File output = new File(dir, quizFileName);
        output.createNewFile();
        XMLOutputter outputter = new XMLOutputter();
        FileOutputStream stream = new FileOutputStream(output);
        outputter.output(doc, (OutputStream)stream);
        stream.close();
        return output.getPath();
    }

    private Element createQuestionRef(String address) {
        Element quizRef = new Element(QUESTIONREF);
        Element url = new Element(URL);
        url.setText(address);
        quizRef.addContent(url);
        return quizRef;
    }
}

