/*
 * Decompiled with CFR 0.152.
 */
package slag.editor.views;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import slag.editor.interfaces.AnswerViewInterface;
import slag.editor.interfaces.QuestionViewInterface;
import slag.editor.views.AnswerView;
import slag.editor.views.QuestionUpdatedListner;

public class QuestionView
extends JPanel
implements QuestionViewInterface {
    private Collection<AnswerViewInterface> mAnswerViews = new ArrayList<AnswerViewInterface>();
    private JComboBox cmbQuestionType = new JComboBox();
    private JLabel lblQuestionType = new JLabel("Question Type:");
    private JTextField txtQuestionText = new JTextField(12);
    private JLabel lblQuestionText = new JLabel("Question Text:");
    private JLabel lblError = new JLabel();
    private JPanel pnlAnswerArea = new JPanel();
    private JButton btnAddAnswer = new JButton();
    private JPanel answersPanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane(this.pnlAnswerArea);
    private ButtonGroup radioButtonGroup = new ButtonGroup();
    private QuestionUpdatedListner mUpdateListner = null;

    public QuestionView() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel textPanel = new JPanel();
        textPanel.add(this.lblQuestionText);
        textPanel.add(this.txtQuestionText);
        this.txtQuestionText.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (QuestionView.this.mUpdateListner != null) {
                    QuestionView.this.mUpdateListner.ActionPerformed();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        textPanel.add(this.lblQuestionType);
        textPanel.add(this.cmbQuestionType);
        mainPanel.add(textPanel);
        mainPanel.add(this.lblError);
        this.cmbQuestionType.addItem("multiple_choice");
        this.cmbQuestionType.addItem("true_false");
        this.cmbQuestionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String questionType = QuestionView.this.getQuestionType();
                QuestionView.this.mAnswerViews.clear();
                QuestionView.this.pnlAnswerArea.removeAll();
                Enumeration<AbstractButton> buttons = QuestionView.this.radioButtonGroup.getElements();
                while (buttons.hasMoreElements()) {
                    QuestionView.this.radioButtonGroup.remove(buttons.nextElement());
                }
                if (questionType.equals("multiple_choice")) {
                    QuestionView.this.answersPanel.setVisible(true);
                    QuestionView.this.btnAddAnswer.setVisible(true);
                    QuestionView.this.scrollPane.setVisible(true);
                } else if (questionType.equals("true_false")) {
                    QuestionView.this.btnAddAnswer.setVisible(false);
                    QuestionView.this.pnlAnswerArea.setVisible(true);
                    QuestionView.this.scrollPane.setVisible(true);
                    AnswerViewInterface newAnswer = QuestionView.this.createAnswerView();
                    newAnswer.setAnswerText("true");
                    newAnswer = QuestionView.this.createAnswerView();
                    newAnswer.setAnswerText("false");
                } else {
                    QuestionView.this.answersPanel.setVisible(false);
                    QuestionView.this.scrollPane.setVisible(false);
                }
                QuestionView.this.pnlAnswerArea.updateUI();
                QuestionView.this.updateUI();
            }
        });
        this.pnlAnswerArea.setLayout(new BoxLayout(this.pnlAnswerArea, 3));
        this.scrollPane.setPreferredSize(new Dimension(350, 200));
        this.answersPanel.add(this.scrollPane);
        this.answersPanel.add(this.btnAddAnswer);
        this.btnAddAnswer.setVerticalAlignment(1);
        mainPanel.add(this.answersPanel);
        this.btnAddAnswer.setText("Add Answer");
        this.btnAddAnswer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                this.addAnswer();
            }

            private void addAnswer() {
                QuestionView.this.createAnswerView();
                QuestionView.this.pnlAnswerArea.updateUI();
                QuestionView.this.updateUI();
            }
        });
        this.add(mainPanel);
    }

    @Override
    public void clearAnswers() {
        this.mAnswerViews.clear();
        this.pnlAnswerArea.removeAll();
    }

    @Override
    public AnswerViewInterface createAnswerView() {
        AnswerView view = new AnswerView();
        this.mAnswerViews.add(view);
        this.radioButtonGroup.add(view.getIsCorrectAnswerRadio());
        JPanel viewPanel = new JPanel();
        viewPanel.add(view);
        if (!this.getQuestionType().equals("true_false")) {
            JButton deleteButton = new JButton("Delete");
            deleteButton.addActionListener(new deleteAnswerHandler(view, viewPanel));
            viewPanel.add(deleteButton);
        }
        this.pnlAnswerArea.add(viewPanel);
        return view;
    }

    @Override
    public Collection<AnswerViewInterface> getAnswerViews() {
        return this.mAnswerViews;
    }

    @Override
    public String getQuestionType() {
        return this.cmbQuestionType.getSelectedItem().toString();
    }

    @Override
    public String getText() {
        return this.txtQuestionText.getText();
    }

    @Override
    public void setQuestionType(String questionType) {
        this.cmbQuestionType.setSelectedItem(questionType);
    }

    @Override
    public void setText(String text) {
        this.txtQuestionText.setText(text);
    }

    @Override
    public void setTextError(boolean valid) {
        if (valid) {
            this.lblError.setText("");
        } else {
            this.lblError.setText("<html><font color='red'>Question Text cannot be empty</font><html>");
        }
    }

    @Override
    public void setIsAnswerSelected(boolean valid) {
        if (valid) {
            this.lblError.setText("");
        } else {
            this.lblError.setText("<html><font color='red'>A question must have one correct answer</font><html>");
        }
    }

    @Override
    public void addQuestionUpdatedListner(QuestionUpdatedListner listner) {
        this.mUpdateListner = listner;
    }

    private class deleteAnswerHandler
    implements ActionListener {
        private AnswerViewInterface mTargetView;
        private JPanel mViewPanel;

        public deleteAnswerHandler(AnswerViewInterface view, JPanel viewPanel) {
            this.mTargetView = view;
            this.mViewPanel = viewPanel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            QuestionView.this.mAnswerViews.remove(this.mTargetView);
            QuestionView.this.pnlAnswerArea.remove(this.mViewPanel);
            QuestionView.this.pnlAnswerArea.updateUI();
        }
    }
}

