/*
 * Decompiled with CFR 0.152.
 */
package slag.editor.views;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import slag.editor.interfaces.QuestionViewInterface;
import slag.editor.interfaces.QuizViewInterface;
import slag.editor.views.QuestionUpdatedListner;
import slag.editor.views.QuestionView;

public class QuizView
extends JPanel
implements QuizViewInterface {
    private Collection<QuestionViewInterface> mQuestionViews = new ArrayList<QuestionViewInterface>();
    private Collection<QuestionListView> mQuestionListViews = new ArrayList<QuestionListView>();
    private JTextField mQuizDescription = new JTextField(12);
    private JTextField mQuizTitle = new JTextField(12);
    private JCheckBox mRandomAnswers = new JCheckBox();
    private JCheckBox mRandomQuestion = new JCheckBox();
    private JButton mAddQuestion = new JButton();
    private JPanel mQuestionList = new JPanel();
    private JPanel mQuestionPanel = new JPanel();
    private JLabel mQuizTitleError = new JLabel();

    public QuizView() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        this.mRandomAnswers.setText("Randomize Answers:");
        this.mRandomQuestion.setText("Randomize Questions:");
        this.mAddQuestion.setText("Add Question");
        JPanel tempPanel = new JPanel();
        tempPanel.add(this.createPanel("Title:", this.mQuizTitle));
        tempPanel.add(this.createPanel("Description:", this.mQuizDescription));
        mainPanel.add(tempPanel);
        mainPanel.add(this.mQuizTitleError);
        JPanel panel = new JPanel();
        panel.add(this.mRandomAnswers);
        panel.add(this.mRandomQuestion);
        mainPanel.add(panel);
        this.mQuestionList.setLayout(new BoxLayout(this.mQuestionList, 3));
        mainPanel.add(this.mAddQuestion);
        this.mAddQuestion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                QuizView.this.createQuestionView();
                QuizView.this.updateUI();
            }
        });
        JPanel questionArea = new JPanel();
        questionArea.setSize(500, 400);
        JScrollPane scrollPane = new JScrollPane(this.mQuestionList);
        scrollPane.setPreferredSize(new Dimension(250, 400));
        questionArea.add(scrollPane);
        this.mQuestionPanel.add(new QuestionView());
        questionArea.add(this.mQuestionPanel);
        mainPanel.add(questionArea);
        this.add(mainPanel);
    }

    @Override
    public void update() {
        for (QuestionListView lv : this.mQuestionListViews) {
            lv.update();
        }
    }

    private JPanel createPanel(String title, JTextField comp) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        label.setHorizontalAlignment(2);
        comp.setHorizontalAlignment(2);
        comp.setColumns(40);
        label.setText(title);
        panel.add(label);
        panel.add(comp);
        return panel;
    }

    @Override
    public QuestionViewInterface createQuestionView() {
        QuestionView view = new QuestionView();
        view.setText("New Question");
        QuestionListView lv = new QuestionListView(view);
        lv.setAlignmentX(0.0f);
        lv.setAlignmentY(0.0f);
        this.mQuestionList.add(lv);
        this.mQuestionListViews.add(lv);
        this.mQuestionViews.add(view);
        return view;
    }

    @Override
    public Collection<QuestionViewInterface> getQuestionViews() {
        return this.mQuestionViews;
    }

    @Override
    public String getQuizDescription() {
        return this.mQuizDescription.getText();
    }

    @Override
    public String getQuizTitle() {
        return this.mQuizTitle.getText();
    }

    @Override
    public boolean getRandomizeAnswers() {
        return this.mRandomAnswers.isSelected();
    }

    @Override
    public boolean getRandomizeQuestions() {
        return this.mRandomQuestion.isSelected();
    }

    @Override
    public void setQuizDescription(String description) {
        this.mQuizDescription.setText(description);
    }

    @Override
    public void setQuizTitle(String title) {
        this.mQuizTitle.setText(title);
    }

    @Override
    public void setRandomizeAnswers(boolean randomizeAnswers) {
        this.mRandomAnswers.setSelected(randomizeAnswers);
    }

    @Override
    public void setRandomizeQuestions(boolean randomizeQuestions) {
        this.mRandomQuestion.setSelected(randomizeQuestions);
    }

    @Override
    public void setQuizTitleError(boolean valid) {
        if (valid) {
            this.mQuizTitleError.setText("");
        } else {
            this.mQuizTitleError.setText("<html><font color='red'>Please enter a title</font></html>");
        }
    }

    private class QuestionListView
    extends JPanel
    implements QuestionUpdatedListner {
        private JLabel mQuestionText = new JLabel();
        private JButton mDeleteButton = new JButton();
        private JButton mDetailsButton = new JButton();
        private QuestionView mCurrentView;

        public QuestionListView(QuestionView view) {
            FlowLayout layout = new FlowLayout();
            layout.setAlignment(0);
            this.setLayout(layout);
            this.mCurrentView = view;
            this.mCurrentView.addQuestionUpdatedListner(this);
            this.update();
            this.mDetailsButton.setText("Details");
            this.mDetailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuizView.this.mQuestionPanel.removeAll();
                    QuizView.this.mQuestionPanel.add(QuestionListView.this.mCurrentView);
                    QuizView.this.mQuestionPanel.updateUI();
                }
            });
            this.mDeleteButton.setText("Delete");
            this.mDeleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuestionListView.this.Delete();
                }
            });
            JPanel content = new JPanel();
            content.add(this.mDetailsButton);
            content.add(this.mDeleteButton);
            content.add(this.mQuestionText);
            this.add(content);
        }

        private void Delete() {
            QuestionView currentVisibleQuestion;
            QuizView.this.mQuestionList.remove(this);
            QuizView.this.mQuestionList.updateUI();
            QuizView.this.mQuestionViews.remove(this.mCurrentView);
            if (QuizView.this.mQuestionPanel.getComponentCount() > 0 && (currentVisibleQuestion = (QuestionView)QuizView.this.mQuestionPanel.getComponent(0)) == this.mCurrentView) {
                QuizView.this.mQuestionPanel.removeAll();
                QuizView.this.mQuestionPanel.add(new QuestionView());
                QuizView.this.mQuestionPanel.updateUI();
            }
        }

        public void update() {
            this.mQuestionText.setText(this.mCurrentView.getText());
        }

        @Override
        public void ActionPerformed() {
            this.update();
        }
    }
}

