/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.diva.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import uk.ac.reload.diva.util.ObjectPath;

public class FilePath
implements ObjectPath {
    private File _file;
    private String _params;

    public FilePath(File file) {
        this._file = file;
    }

    public FilePath(File file, String params) {
        this._file = file;
        this._params = params;
    }

    @Override
    public String getURL() {
        String path = null;
        URI uri = this._file.toURI();
        try {
            URL url = uri.toURL();
            path = url.getPath();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        if (this._params != null) {
            path = path + this._params;
        }
        if (this._file.getAbsolutePath().startsWith("\\\\")) {
            path = path.replaceAll("/", "\\\\");
        }
        if (path.startsWith("/")) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    @Override
    public String getPath() {
        String path = this._file.getAbsolutePath();
        return path;
    }
}

