/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import uk.ac.reload.dweezil.gui.ReloadInternalFrame;

public class ReloadInternalFrameManager {
    protected static int _xpos = -25;
    protected static int _ypos = -25;
    protected static final int WINDOWGAP = 25;
    protected static final double SIZE_FACTOR = 0.9;
    private JDesktopPane _desktop;
    private static Hashtable FileToWindowMAP = new Hashtable();

    public ReloadInternalFrameManager(JDesktopPane desktop) {
        this._desktop = desktop;
    }

    public void addInternalFrame(ReloadInternalFrame frame) {
        int height;
        int width = (int)((double)this._desktop.getWidth() * 0.9);
        if (width < 100) {
            width = 100;
        }
        if ((height = (int)((double)this._desktop.getHeight() * 0.9)) < 100) {
            height = 100;
        }
        if ((_xpos += 25) + width > this._desktop.getWidth() || (_ypos += 25) + height > this._desktop.getHeight()) {
            _xpos = 0;
            _ypos = 0;
        }
        frame.setBounds(_xpos, _ypos, width, height);
        this._desktop.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
    }

    public void removeInternalFrame(ReloadInternalFrame frame) {
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length > 0) {
            try {
                frames[frames.length - 1].setSelected(true);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
        ReloadInternalFrameManager.removeInternalFrameFromWindowMap(frame);
    }

    public void cascade() {
        int height;
        int width = (int)((double)this._desktop.getWidth() * 0.9);
        if (width < 100) {
            width = 100;
        }
        if ((height = (int)((double)this._desktop.getHeight() * 0.9)) < 100) {
            height = 100;
        }
        _xpos = -25;
        _ypos = -25;
        JInternalFrame[] frames = this._desktop.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            if ((_xpos += 25) + width > this._desktop.getWidth() || (_ypos += 25) + height > this._desktop.getHeight()) {
                _xpos = 0;
                _ypos = 0;
            }
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
                continue;
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    public void tileVertical() {
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int height = this._desktop.getHeight();
        int width = this._desktop.getWidth() / frames.length;
        _xpos = 0;
        _ypos = 0;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            _xpos += width;
        }
    }

    public void tileHorizontal() {
        JInternalFrame[] frames = this._desktop.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        int height = this._desktop.getHeight() / frames.length;
        int width = this._desktop.getWidth();
        _xpos = 0;
        _ypos = 0;
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame f = frames[i];
            try {
                f.setIcon(false);
                f.setMaximum(false);
                f.setBounds(_xpos, _ypos, width, height);
                f.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            _ypos += height;
        }
    }

    public static ReloadInternalFrame getReloadInternalFrame(File file) {
        return file == null ? null : (ReloadInternalFrame)FileToWindowMAP.get(file);
    }

    public static void addReloadInternalFrameToWindowMap(File file, ReloadInternalFrame frame) {
        if (frame != null) {
            ReloadInternalFrameManager.removeInternalFrameFromWindowMap(frame);
        }
        if (file != null && frame != null) {
            FileToWindowMAP.put(file, frame);
        }
    }

    private static void removeInternalFrameFromWindowMap(ReloadInternalFrame frame) {
        if (frame != null && FileToWindowMAP.contains(frame)) {
            Enumeration e = FileToWindowMAP.keys();
            while (e.hasMoreElements()) {
                File file = (File)e.nextElement();
                ReloadInternalFrame f = (ReloadInternalFrame)FileToWindowMAP.get(file);
                if (frame != f) continue;
                FileToWindowMAP.remove(file);
            }
        }
    }
}

