/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ReloadProgressMonitor {
    private JDialog dialog;
    private JOptionPane pane;
    private JProgressBar myBar;
    private JLabel messageLabel;
    private JLabel noteLabel;
    private String message;
    private String note;
    private Object[] cancelOption = null;
    private int max;
    private int progress;

    public ReloadProgressMonitor(Component parentComponent, String title, String message, String note, boolean indeterminate, Icon icon) {
        if (title == null) {
            title = " ";
        }
        if (message == null) {
            message = " ";
        }
        if (note == null) {
            note = " ";
        }
        this.cancelOption = new Object[1];
        this.cancelOption[0] = UIManager.getString("OptionPane.cancelButtonText");
        this.myBar = new JProgressBar();
        this.myBar.setIndeterminate(indeterminate);
        this.myBar.setPreferredSize(new Dimension(300, this.myBar.getPreferredSize().height));
        this.messageLabel = new JLabel(message);
        this.noteLabel = new JLabel(note);
        this.pane = new ProgressOptionPane(new Object[]{this.messageLabel, this.noteLabel, this.myBar}, icon);
        this.dialog = this.pane.createDialog(parentComponent, title);
        this.dialog.show();
    }

    public void init(int max) {
        this.max = max;
        this.myBar.setMaximum(max);
        this.setProgress(0, false);
    }

    public void init(String message, String note, int max) {
        this.init(max);
        this.setMessage(message);
        this.setNote(note);
    }

    public void setProgress(int progress, boolean closeOnMax) {
        if (this.myBar != null) {
            this.progress = progress;
            this.myBar.setValue(progress);
            if (closeOnMax && progress >= this.max) {
                this.close();
            }
        }
    }

    public void incProgress(int inc, boolean closeOnMax) {
        this.setProgress(this.progress + inc, closeOnMax);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.myBar.setIndeterminate(indeterminate);
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
        this.pane = null;
        this.myBar = null;
    }

    public void setMessage(String message) {
        this.message = message;
        this.messageLabel.setText(message == null ? " " : message);
    }

    public void setNote(String note) {
        this.note = note;
        this.noteLabel.setText(note == null ? " " : note);
    }

    public boolean isCanceled() {
        if (this.pane == null) {
            return false;
        }
        Object v = this.pane.getValue();
        return v != null && this.cancelOption.length == 1 && v.equals(this.cancelOption[0]);
    }

    private class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object messageList, Icon icon) {
            super(messageList, 1, -1, icon, ReloadProgressMonitor.this.cancelOption, null);
        }

        @Override
        public int getMaxCharactersPerLineCount() {
            return 80;
        }

        @Override
        public JDialog createDialog(Component parentComponent, String title) {
            Frame frame = JOptionPane.getFrameForComponent(parentComponent);
            final JDialog dialog = new JDialog(frame, title, false);
            Container contentPane = dialog.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo(parentComponent);
            dialog.addWindowListener(new WindowAdapter(){
                boolean gotFocus = false;

                @Override
                public void windowClosing(WindowEvent we) {
                    ProgressOptionPane.this.setValue(null);
                }

                @Override
                public void windowActivated(WindowEvent we) {
                    if (!this.gotFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.gotFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (dialog.isVisible() && event.getSource() == ProgressOptionPane.this && (event.getPropertyName().equals("value") || event.getPropertyName().equals("inputValue"))) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                }
            });
            return dialog;
        }
    }
}

