/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import uk.ac.reload.dweezil.DweezilConstants;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.util.ReloadUtils;

public class ReloadStatusWindow
extends JFrame
implements DweezilConstants {
    protected boolean _macKludge;
    protected JTextArea _editor;
    protected String _appName;
    protected String _appVersion;
    protected String _buildDate;

    public ReloadStatusWindow(String appName, String appVersion, String buildDate, ImageIcon icon, boolean redirect) {
        super(appName + " - Status Window");
        this._appName = appName;
        this._appVersion = appVersion;
        this._buildDate = buildDate;
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        this._editor = new JTextArea();
        this._editor.setEditable(false);
        this._editor.setCursor(ReloadUIManager.TEXT_CURSOR);
        this.getContentPane().add((Component)new JScrollPane(this._editor), "Center");
        JMenuBar menuBar = this.constructMenuBar();
        this.setJMenuBar(menuBar);
        ReloadUtils.centreWindow(this, 450, 400);
        this.setDefaultCloseOperation(1);
        boolean bl = this._macKludge = ReloadUtils.getOS() == 0;
        if (redirect) {
            try {
                PrintStream output = new PrintStream(new DumpStream(), true);
                PrintStream err = new PrintStream(new ErrorStream(), true);
                System.setOut(output);
                System.setErr(err);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        System.out.println(appName + " version:\t" + appVersion + " (" + buildDate + ")");
        System.out.println("Java version:\t\t" + System.getProperties().getProperty("java.version"));
        System.out.println("Started at:\t\t" + ReloadUtils.parseDate(ReloadUtils.getNow()));
        System.out.println("User Home:\t\t" + System.getProperties().getProperty("user.home"));
        System.out.println("User Name:\t\t" + System.getProperties().getProperty("user.name"));
        System.out.println();
    }

    public void showWindow() {
        this.setVisible(true);
    }

    public static void printTrace(String message) {
        boolean trace = true;
        if (trace) {
            System.out.println(message);
        }
    }

    private JMenuBar constructMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu fileMenu = mb.add(new JMenu("File"));
        JMenuItem menuItem = fileMenu.add(new JMenuItem("Clear"));
        menuItem.addActionListener(new Action_Clear());
        menuItem = fileMenu.add(new JMenuItem("Save to File..."));
        menuItem.addActionListener(new Action_Save());
        menuItem = fileMenu.add(new JMenuItem("Garbage Collect"));
        menuItem.addActionListener(new Action_GC());
        return mb;
    }

    private class Action_Save
    extends AbstractAction {
        private Action_Save() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(ReloadStatusWindow.this);
            if (returnVal != 0) {
                return;
            }
            try {
                File file = chooser.getSelectedFile();
                BufferedWriter out = new BufferedWriter(new FileWriter(file));
                out.write(ReloadStatusWindow.this._editor.getText());
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                System.out.println("Status log save error " + ex);
            }
        }
    }

    private class Action_GC
    extends AbstractAction {
        private Action_GC() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            float freeMem = (float)rt.freeMemory() / 1024.0f / 1024.0f;
            System.out.println("Free Mem:\t\t" + freeMem + " Mb");
            float totalMem = (float)rt.totalMemory() / 1024.0f / 1024.0f;
            System.out.println("Total Mem:\t\t" + totalMem + " Mb");
            System.out.println();
        }
    }

    private class Action_Clear
    extends AbstractAction {
        private Action_Clear() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReloadStatusWindow.this._editor.setText("");
        }
    }

    private class ErrorStream
    extends DumpStream {
        File file;
        FileWriter writer;
        boolean dateWritten;
        boolean canWrite;

        public ErrorStream() {
            this.canWrite = true;
            this.openErrorFile();
        }

        @Override
        public void write(int b) {
            if (this.canWrite) {
                try {
                    if (!this.dateWritten) {
                        this.dateWritten = true;
                        this.writeDate();
                    }
                    this.writer.write(b);
                    this.writer.flush();
                }
                catch (IOException ex) {
                    this.canWrite = false;
                }
            }
            super.write(b);
        }

        private void openErrorFile() {
            String folder = System.getProperty("user.dir");
            String logName = "reload.log";
            this.file = new File(folder, logName);
            try {
                if (this.file.length() > 131072L) {
                    Date date = new Date();
                    File tmp = new File(folder + "reload" + date.getTime() + ".log");
                    this.file.renameTo(tmp);
                    this.file = new File(folder + logName);
                }
                this.writer = new FileWriter(this.file.getPath(), true);
            }
            catch (IOException ex) {
                this.canWrite = false;
            }
        }

        private void writeDate() throws IOException {
            this.writer.write("-----------------------------------------------------------------------------" + DweezilConstants.CR);
            this.writer.write(ReloadStatusWindow.this._appName + " version:\t" + ReloadStatusWindow.this._appVersion + " (" + ReloadStatusWindow.this._buildDate + ")" + DweezilConstants.CR);
            this.writer.write("Java version:\t\t" + System.getProperties().getProperty("java.version") + DweezilConstants.CR);
            this.writer.write("Started at:\t\t" + ReloadUtils.parseDate(ReloadUtils.getNow()) + DweezilConstants.CR);
            this.writer.write("-----------------------------------------------------------------------------" + DweezilConstants.CR);
            this.writer.write(DweezilConstants.CR);
            this.writer.flush();
        }
    }

    private class DumpStream
    extends OutputStream {
        String s;

        @Override
        public void write(int b) {
            this.s = String.valueOf((char)(b & 0xFF));
            if (ReloadStatusWindow.this._macKludge && (this.s.equals(DweezilConstants.CR) || this.s.equals("\r"))) {
                ReloadStatusWindow.this._editor.append("\r\n");
            } else {
                ReloadStatusWindow.this._editor.append(this.s);
            }
            ReloadStatusWindow.this._editor.setCaretPosition(ReloadStatusWindow.this._editor.getText().length());
        }
    }
}

