/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ReloadUIManager {
    public static Cursor TEXT_CURSOR = Cursor.getPredefinedCursor(2);
    public static Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    public static Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    public static Font plainFont11 = new Font("SansSerif", 0, 11);
    public static Font boldFont11 = new Font("SansSerif", 1, 11);
    public static Font italicFont11 = new Font("SansSerif", 2, 11);
    public static Font bold_italicFont11 = new Font("SansSerif", 3, 11);
    public static Font plainFont12 = new Font("SansSerif", 0, 12);
    public static Font boldFont12 = new Font("SansSerif", 1, 12);
    public static Font italicFont12 = new Font("SansSerif", 2, 12);
    public static Font bold_italicFont12 = new Font("SansSerif", 3, 12);
    public static Font plainFont13 = new Font("SansSerif", 0, 13);
    public static Font boldFont13 = new Font("SansSerif", 1, 13);
    public static Font italicFont13 = new Font("SansSerif", 2, 13);
    public static Font bold_italicFont13 = new Font("SansSerif", 3, 13);
    public static Font plainFont14 = new Font("SansSerif", 0, 14);
    public static Font boldFont14 = new Font("SansSerif", 1, 14);
    private static Hashtable icons = new Hashtable();

    public static void setMacUIDefaults(String applicationName) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", applicationName);
        System.setProperty("apple.awt.showGrowBox", "true");
    }

    public static void setLookAndFeel(String className, Component[] components) {
        try {
            UIManager.setLookAndFeel(className);
            ReloadUIManager.updateComponentTreeUI(components);
        }
        catch (Exception ex) {
            try {
                String lf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(lf);
                ReloadUIManager.updateComponentTreeUI(components);
            }
            catch (Exception ex1) {
                System.out.println("Error loading L&F: " + ex);
            }
        }
    }

    private static void updateComponentTreeUI(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            SwingUtilities.updateComponentTreeUI(components[i]);
        }
    }

    public static ImageIcon getIcon(String iconPath) {
        try {
            ImageIcon imageIcon = (ImageIcon)icons.get(iconPath);
            if (imageIcon == null) {
                URL url = icons.getClass().getResource(iconPath);
                if (url == null) {
                    return null;
                }
                imageIcon = new ImageIcon(url);
                icons.put(iconPath, imageIcon);
            }
            return imageIcon;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Image getImage(String imagePath) {
        ImageIcon imageIcon = ReloadUIManager.getIcon(imagePath);
        if (imageIcon != null) {
            return imageIcon.getImage();
        }
        return null;
    }
}

