/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.tree;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.tree.ReloadTree;
import uk.ac.reload.dweezil.gui.tree.ReloadTreeNode;
import uk.ac.reload.dweezil.util.ReloadUtils;

public abstract class ReloadDragTree
extends ReloadTree
implements DragSourceListener,
DragGestureListener,
DropTargetListener,
Autoscroll {
    protected ReloadTreeNode prevHilitedNode;
    private TreePath _pathLast;
    private Timer _timerHover = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ReloadDragTree.this.isRootPath(ReloadDragTree.this._pathLast)) {
                return;
            }
            if (ReloadDragTree.this.isCollapsed(ReloadDragTree.this._pathLast)) {
                ReloadDragTree.this.expandPath(ReloadDragTree.this._pathLast);
            }
        }
    });

    public ReloadDragTree() {
        this._timerHover.setRepeats(false);
    }

    protected void hiliteNode(ReloadTreeNode node, boolean hilite) {
        if (node == null) {
            return;
        }
        if (this.prevHilitedNode != null && node != this.prevHilitedNode) {
            this.prevHilitedNode.isHiLited = false;
        }
        if (node.isHiLited != hilite) {
            node.isHiLited = hilite;
            this.repaint();
            this.prevHilitedNode = node;
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle r = this.getVisibleRect();
        Dimension s = this.getSize();
        Insets insets = new Insets(r.y + 50, r.x, s.height - r.y - r.height + 50, s.width - r.x - r.width);
        return insets;
    }

    @Override
    public void autoscroll(Point cursorLocn) {
        Rectangle v = this.getVisibleRect();
        int y = cursorLocn.y < v.y + 50 ? cursorLocn.y - 40 : cursorLocn.y;
        Rectangle r = new Rectangle(0, y, this.getVisibleRect().width, 40);
        this.scrollRectToVisible(r);
    }

    protected ReloadTreeNode getDragSourceTreeNode(DragGestureEvent event) {
        ReloadTreeNode node = null;
        Point location = event.getDragOrigin();
        TreePath dragPath = this.getPathForLocation(location.x, location.y);
        if (dragPath != null && this.isPathSelected(dragPath)) {
            node = (ReloadTreeNode)dragPath.getLastPathComponent();
        }
        return node;
    }

    protected ReloadTreeNode getDragOverTreeNode(DropTargetDragEvent event) {
        ReloadTreeNode node = null;
        Point location = event.getLocation();
        TreePath dragPath = this.getPathForLocation(location.x, location.y);
        if (dragPath != null) {
            node = (ReloadTreeNode)dragPath.getLastPathComponent();
        }
        return node;
    }

    public BufferedImage getDragImage(TreePath path, Point ptDragOrigin) {
        Point ptOffset = new Point();
        Rectangle raPath = this.getPathBounds(path);
        ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        BufferedImage imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        return imgGhost;
    }

    public abstract boolean isDropOK(DropTargetDragEvent var1);

    @Override
    public void dragExit(DragSourceEvent event) {
        DragSourceContext context = event.getDragSourceContext();
        context.setCursor(DragSource.DefaultCopyNoDrop);
        this.hiliteNode(this.prevHilitedNode, false);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
        DragSourceContext context = event.getDragSourceContext();
        int action = event.getDropAction();
        if ((action & 1) != 0) {
            context.setCursor(DragSource.DefaultCopyDrop);
        } else if ((action & 2) != 0) {
            context.setCursor(DragSource.DefaultMoveDrop);
        } else {
            context.setCursor(DragSource.DefaultCopyNoDrop);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        this.hiliteNode(this.prevHilitedNode, false);
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(this.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
        boolean ok = this.isDropOK(event);
        if (ok) {
            event.acceptDrag(this.getCorrectDropContext(event));
            ReloadTreeNode node = this.getDragOverTreeNode(event);
            this.hiliteNode(node, true);
        } else {
            event.rejectDrag();
        }
        Point pt = event.getLocation();
        TreePath path = this.getClosestPathForLocation(pt.x, pt.y);
        if (path != this._pathLast) {
            this._pathLast = path;
            this._timerHover.restart();
        }
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.hiliteNode(this.prevHilitedNode, false);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
        if (this.isDropOK(event)) {
            event.acceptDrag(this.getCorrectDropContext(event));
        } else {
            event.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
    }

    public int getCorrectDropContext(DropTargetDropEvent event) {
        int OS = ReloadUtils.getOS();
        if (OS == 0) {
            int result = event.getDropAction();
            switch (result) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 1;
        }
        return event.getDropAction();
    }

    public int getCorrectDropContext(DropTargetDragEvent event) {
        int OS = ReloadUtils.getOS();
        if (OS == 0) {
            int result = event.getDropAction();
            switch (result) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
            return 1;
        }
        return event.getDropAction();
    }
}

