/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.tree;

import java.io.File;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Document;
import org.jdom.Element;
import uk.ac.reload.dweezil.gui.tree.ReloadTreeModel;
import uk.ac.reload.dweezil.gui.tree.ReloadTreeNode;
import uk.ac.reload.dweezil.util.DweezilXMLException;
import uk.ac.reload.dweezil.util.XMLUtils;

public abstract class ReloadTree
extends JTree {
    protected boolean dirtyTree;

    protected boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    public synchronized ReloadTreeNode selectNodeByObject(Object anObject) {
        if (anObject == null) {
            return null;
        }
        ReloadTreeNode node = this.getNode(anObject);
        this.selectNode(node);
        return node;
    }

    public synchronized void selectNode(final DefaultMutableTreeNode node) {
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath path = new TreePath(node.getPath());
                    ReloadTree.this.scrollPathToVisible(path);
                    ReloadTree.this.setSelectionPath(path);
                }
            });
        }
    }

    public ReloadTreeNode getSelectedNode() {
        TreePath selPath = this.getSelectionPath();
        return selPath == null ? null : (ReloadTreeNode)selPath.getLastPathComponent();
    }

    public ReloadTreeNode getNode(Object object) {
        if (object == null) {
            return null;
        }
        Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)this.treeModel.getRoot()).preorderEnumeration();
        while (nodes.hasMoreElements()) {
            ReloadTreeNode node = (ReloadTreeNode)nodes.nextElement();
            Object o = node.getUserObject();
            if (o != object) continue;
            return node;
        }
        return null;
    }

    public void expandNode(Object anObject, boolean expand) {
        ReloadTreeNode node = this.getNode(anObject);
        this.expandNode(node, expand);
    }

    public void expandNode(DefaultMutableTreeNode node, boolean expand) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            int row = this.getRowForPath(path);
            if (row >= 0) {
                if (expand) {
                    this.expandRow(row);
                } else {
                    this.collapseRow(row);
                }
            } else if (expand) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }
    }

    protected void scrollNodeToVisible(DefaultMutableTreeNode node) {
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.scrollPathToVisible(path);
        }
    }

    public void updateSelectedNode() {
        ReloadTreeNode node = this.getSelectedNode();
        if (node != null) {
            ((ReloadTreeModel)this.getModel()).nodeChanged(node);
        }
    }

    public void updateNodes() {
        ReloadTreeModel treeModel = (ReloadTreeModel)this.getModel();
        Enumeration<TreeNode> nodes = ((ReloadTreeModel)this.getModel()).getRootNode().preorderEnumeration();
        while (nodes.hasMoreElements()) {
            ReloadTreeNode node = (ReloadTreeNode)nodes.nextElement();
            treeModel.nodeChanged(node);
        }
    }

    public String getExpandedNodes() {
        int count = 0;
        StringBuffer sb = new StringBuffer();
        Enumeration<TreeNode> nodes = ((ReloadTreeModel)this.getModel()).getRootNode().preorderEnumeration();
        while (nodes.hasMoreElements()) {
            ReloadTreeNode node = (ReloadTreeNode)nodes.nextElement();
            if (node.isExpanded) {
                sb.append(":");
                sb.append(count);
            }
            ++count;
        }
        sb.append(":");
        return sb.toString();
    }

    public void expandedNodes(String nodeSet) {
        if (nodeSet != null) {
            int count = 0;
            Enumeration<TreeNode> nodes = ((ReloadTreeModel)this.getModel()).getRootNode().preorderEnumeration();
            while (nodes.hasMoreElements()) {
                ReloadTreeNode node = (ReloadTreeNode)nodes.nextElement();
                if (nodeSet.indexOf(":" + count + ":") != -1) {
                    this.expandNode(node, true);
                }
                ++count;
            }
        }
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        ReloadTreeNode node = (ReloadTreeNode)path.getLastPathComponent();
        node.isExpanded = true;
        this.dirtyTree = true;
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        ReloadTreeNode node = (ReloadTreeNode)path.getLastPathComponent();
        node.isExpanded = false;
        this.dirtyTree = true;
    }

    public boolean isDirtyTree() {
        return this.dirtyTree;
    }

    public void expandTree(boolean expand) {
        ReloadTreeNode rootNode = ((ReloadTreeModel)this.getModel()).getRootNode();
        Enumeration<TreeNode> nodes = expand ? rootNode.preorderEnumeration() : rootNode.postorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)nodes.nextElement();
            this.expandNode(theNode, expand);
        }
    }

    public void writeState(File file) {
        Element docRoot = new Element("tree_state");
        Document doc = new Document(docRoot);
        Element element = new Element("expanded_nodes");
        element.setText(this.getExpandedNodes());
        docRoot.addContent(element);
        try {
            XMLUtils.write2XMLFile(doc, file);
            this.dirtyTree = false;
        }
        catch (DweezilXMLException ex) {
            System.out.println("writeState Error: " + ex);
        }
    }

    public void loadState(File file) {
        String nodeSet = null;
        if (file.exists()) {
            try {
                Document source = XMLUtils.readXMLFile(file);
                Element element = source.getRootElement().getChild("expanded_nodes");
                if (element != null) {
                    nodeSet = element.getText().trim();
                }
                this.expandedNodes(nodeSet);
            }
            catch (DweezilXMLException ex) {
                System.out.println("loadState Error: " + ex);
            }
        }
        this.dirtyTree = false;
    }
}

