/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.treetable;

import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uk.ac.reload.dweezil.gui.treetable.JTreeTable;
import uk.ac.reload.dweezil.gui.treetable.ReloadTreeTableModel;

public class ReloadTreeTable
extends JTreeTable {
    protected ReloadTreeTableModel treeTableModel;

    public ReloadTreeTable(ReloadTreeTableModel treeTableModel) {
        super(treeTableModel);
        this.treeTableModel = treeTableModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.revalidate();
        super.tableChanged(e);
    }

    public ReloadTreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    public synchronized void selectNode(final DefaultMutableTreeNode node) {
        if (node != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreePath path = new TreePath(node.getPath());
                    ReloadTreeTable.this.tree.setSelectionPath(path);
                    Rectangle bounds = ReloadTreeTable.this.getCellRect(ReloadTreeTable.this.tree.getRowForPath(path), 0, true);
                    ReloadTreeTable.this.scrollRectToVisible(bounds);
                    ReloadTreeTable.this.tree.setSelectionPath(path);
                }
            });
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.tree.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    public void updateSelectedNode() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node != null) {
            this.treeTableModel.nodeChanged(node);
        }
    }

    public DefaultMutableTreeNode getNode(Object object) {
        if (object == null) {
            return null;
        }
        Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)this.treeTableModel.getRoot()).preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Object o = node.getUserObject();
            if (o != object) continue;
            return node;
        }
        return null;
    }
}

