/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import uk.ac.reload.dweezil.gui.ReloadFileChooser;
import uk.ac.reload.dweezil.gui.ReloadFolderChooser;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;
import uk.ac.reload.dweezil.util.ReloadUtils;

public class ReloadFileTextField
extends JPanel
implements ReloadWidget {
    protected int _maxLength;
    protected JTextField _textField;
    protected JButton _button;
    protected ReloadFileChooser _chooser;
    protected String _text;
    protected int _type;
    protected File _relativePath;
    public static int FILE_TYPE = 1;
    public static int FOLDER_TYPE = 2;

    public ReloadFileTextField(int type, String text, Icon icon) {
        super(new BorderLayout());
        this._type = type;
        this._text = text;
        this._textField = new JTextField();
        this._textField.setFont(ReloadUIManager.plainFont11);
        this.add((Component)this._textField, "Center");
        this._button = new JButton(icon);
        this.add((Component)this._button, "East");
        this.setupAction();
    }

    protected void setupAction() {
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if (ReloadFileTextField.this._chooser == null) {
                    ReloadFileTextField.this._chooser = ReloadFileTextField.this._type == FILE_TYPE ? new ReloadFileChooser() : new ReloadFolderChooser();
                    ReloadFileTextField.this._chooser.setDialogTitle(ReloadFileTextField.this._text);
                    ReloadFileTextField.this._chooser.setApproveButtonText("Select");
                }
                if ((returnVal = ReloadFileTextField.this._chooser.showOpenDialog(null)) == 0) {
                    File file = ReloadFileTextField.this._chooser.getSelectedFileAndStore();
                    String path = ReloadFileTextField.this._relativePath != null && ReloadFileTextField.this._relativePath.exists() ? ReloadUtils.getRelativePath(ReloadFileTextField.this._relativePath, file) : file.getPath();
                    ReloadFileTextField.this.setTextValue(path);
                }
            }
        });
    }

    public JTextField getTextField() {
        return this._textField;
    }

    @Override
    public void setTextValue(String value) {
        this._textField.setText(value);
    }

    @Override
    public void insertTextValue(String text) {
    }

    @Override
    public String getTextValue() {
        return this._textField.getText();
    }

    @Override
    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    @Override
    public boolean isSingleLine() {
        return true;
    }

    public File getRelativePath() {
        return this._relativePath;
    }

    public void setRelativePath(File relativePath) {
        this._relativePath = relativePath;
    }

    @Override
    public void addDocumentListener(DocumentListener dl) {
        this._textField.getDocument().addDocumentListener(dl);
    }

    @Override
    public void removeDocumentListener(DocumentListener dl) {
        this._textField.getDocument().removeDocumentListener(dl);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._textField.setEnabled(enabled);
        this._button.setEnabled(enabled);
    }
}

