/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;

public class ReloadListBox
extends JPanel
implements ReloadWidget,
ListSelectionListener {
    protected int _maxLength;
    protected JTextField textField = new JTextField();
    protected JList listBox;

    public ReloadListBox() {
        super(new BorderLayout());
        this.textField.setFont(ReloadUIManager.plainFont11);
        this.add((Component)this.textField, "North");
        this.listBox = new JList();
        this.listBox.setSelectionMode(0);
        this.add((Component)new JScrollPane(this.listBox), "Center");
        this.listBox.addListSelectionListener(this);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void setListData(Object[] values) {
        this.listBox.setListData(values);
    }

    @Override
    public void setTextValue(String value) {
        this.listBox.setSelectedValue(value, true);
        this.textField.setText(value);
    }

    @Override
    public void insertTextValue(String text) {
    }

    @Override
    public String getTextValue() {
        return this.textField.getText();
    }

    @Override
    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    @Override
    public void addDocumentListener(DocumentListener dl) {
        this.textField.getDocument().addDocumentListener(dl);
    }

    @Override
    public void removeDocumentListener(DocumentListener dl) {
        this.textField.getDocument().removeDocumentListener(dl);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.listBox.setEnabled(enabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object object;
        if (e.getSource() == this.listBox && (object = this.listBox.getSelectedValue()) != null) {
            this.textField.setText(object.toString());
        }
    }
}

