/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.widgets;

import java.util.HashSet;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;

public class ReloadTextArea
extends JTextArea
implements ReloadWidget {
    protected int _maxLength;

    public ReloadTextArea() {
        this.setTabKeyBehaviour();
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setUI();
    }

    private void setUI() {
        this.setFont(UIManager.getFont("TextField.font"));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    protected void setTabKeyBehaviour() {
        HashSet<KeyStroke> forwardTraversalKeys = new HashSet<KeyStroke>();
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        HashSet<KeyStroke> backwardTraversalKeys = new HashSet<KeyStroke>();
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }

    @Override
    public void setTextValue(String value) {
        this.setText(value);
    }

    @Override
    public void insertTextValue(String text) {
    }

    @Override
    public String getTextValue() {
        return this.getText();
    }

    @Override
    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    @Override
    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    @Override
    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }
}

