/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.widgets;

import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;

public class ReloadTextField
extends JTextField
implements ReloadWidget {
    protected int _maxLength;
    protected boolean _doVerify = true;

    public ReloadTextField() {
        this(-1);
    }

    public ReloadTextField(int maxLength) {
        this.setMaxLength(maxLength);
        this.setDocument(new TextFieldVerifier());
        this.setUI();
    }

    @Override
    public void insertTextValue(String text) {
    }

    @Override
    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    protected void setUI() {
        this.setFont(ReloadUIManager.plainFont11);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    @Override
    public void setTextValue(String value) {
        this.setText(value);
    }

    @Override
    public void setText(String value) {
        this._doVerify = false;
        super.setText(value);
        this._doVerify = true;
    }

    @Override
    public String getTextValue() {
        return this.getText();
    }

    @Override
    public boolean isSingleLine() {
        return true;
    }

    @Override
    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    @Override
    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }

    class TextFieldVerifier
    extends PlainDocument {
        protected int _offset = -1;

        TextFieldVerifier() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attSet) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (ReloadTextField.this._doVerify) {
                this._offset = offset;
                boolean valid = this.isLengthOK(str);
                if (!valid) {
                    return;
                }
                valid = this.isStringOK(str);
                if (!valid) {
                    return;
                }
            }
            super.insertString(offset, str, attSet);
        }

        boolean isStringOK(String str) {
            return true;
        }

        boolean isLengthOK(String str) throws BadLocationException {
            String oldStr;
            return ReloadTextField.this._maxLength == -1 || (oldStr = this.getText(0, this.getLength())).length() + str.length() <= ReloadTextField.this._maxLength;
        }
    }
}

