/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.gui.widgets;

import java.util.HashSet;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.gui.widgets.ReloadWidget;

public class ReloadTextPane
extends JTextPane
implements ReloadWidget {
    protected int _maxLength;

    public ReloadTextPane() {
        this.setTabKeyBehaviour();
        this.setUI();
    }

    @Override
    public void setTextValue(String value) {
        this.setText(value);
        this.setCaretPosition(0);
    }

    @Override
    public void insertTextValue(String text) {
        try {
            this.getDocument().insertString(this.getCaretPosition(), text, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public String getTextValue() {
        return this.getText();
    }

    @Override
    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    @Override
    public boolean isSingleLine() {
        return false;
    }

    @Override
    public void addDocumentListener(DocumentListener dl) {
        this.getDocument().addDocumentListener(dl);
    }

    @Override
    public void removeDocumentListener(DocumentListener dl) {
        this.getDocument().removeDocumentListener(dl);
    }

    protected void setUI() {
        this.setFont(ReloadUIManager.plainFont11);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI();
    }

    protected void setTabKeyBehaviour() {
        HashSet<KeyStroke> forwardTraversalKeys = new HashSet<KeyStroke>();
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        this.setFocusTraversalKeys(0, forwardTraversalKeys);
        HashSet<KeyStroke> backwardTraversalKeys = new HashSet<KeyStroke>();
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
        this.setFocusTraversalKeys(1, backwardTraversalKeys);
    }
}

