/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.menu;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import uk.ac.reload.dweezil.gui.ReloadUIManager;
import uk.ac.reload.dweezil.menu.MenuActionListener;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;

public abstract class MenuAction
extends AbstractAction {
    private ImageIcon icon;
    private String text;
    private JButton button;
    private Vector listeners = new Vector();

    public MenuAction() {
        this("", (String)null);
    }

    public MenuAction(String text) {
        this(text, (String)null);
    }

    public MenuAction(String text, String iconPath) {
        this.text = text;
        if (iconPath != null) {
            this.icon = ReloadUIManager.getIcon(iconPath);
        }
        if (this.icon != null) {
            this.setMenuIcon(this.icon);
        }
        this.putValue("Name", text);
        this.button = this.createButton();
    }

    public void setMenuIcon(ImageIcon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setButtonIcon(ImageIcon icon) {
        if (this.button != null) {
            this.button.setIcon(icon);
        }
    }

    public void setText(String text) {
        this.putValue("Name", text);
        if (this.button != null) {
            this.button.setToolTipText(text);
        }
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.button.setEnabled(newValue);
        super.setEnabled(newValue);
    }

    public JButton getButton() {
        return this.button;
    }

    private JButton createButton() {
        JButton button = new JButton();
        if (this.icon != null) {
            button.setIcon(this.icon);
        }
        button.setEnabled(this.isEnabled());
        button.addActionListener(this);
        button.setToolTipText(this.text);
        button.setFocusPainted(false);
        button.setFocusable(false);
        return button;
    }

    public synchronized void addMenuActionListener(MenuActionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public synchronized void removeMenuActionListener(MenuActionListener listener) {
        this.listeners.removeElement(listener);
    }

    public synchronized void removeAllMenuActionListeners() {
        this.listeners.clear();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ReloadMenuEvent menuEvent = new ReloadMenuEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            MenuActionListener listener = (MenuActionListener)this.listeners.elementAt(i);
            listener.menuActionPerformed(menuEvent);
        }
    }
}

