/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.reload.dweezil.menu;

import uk.ac.reload.dweezil.menu.MenuAction;
import uk.ac.reload.dweezil.menu.MenuActionListener;
import uk.ac.reload.dweezil.menu.ReloadMenuEvent;
import uk.ac.reload.dweezil.undo.UndoHandler;
import uk.ac.reload.dweezil.undo.UndoListener;
import uk.ac.reload.dweezil.undo.UndoableAction;

public class ReloadUndoMenuManager
implements UndoListener,
MenuActionListener {
    private UndoHandler undoHandler = new UndoHandler(this);
    private boolean hasFocus = false;
    private MenuAction _actionUndo;
    private MenuAction _actionRedo;

    public ReloadUndoMenuManager(MenuAction actionUndo, MenuAction actionRedo) {
        this._actionUndo = actionUndo;
        this._actionRedo = actionRedo;
    }

    @Override
    public void menuActionPerformed(ReloadMenuEvent event) {
        if (this.hasFocus && event.getSource() == this._actionUndo) {
            this.undoLastAction();
        } else if (this.hasFocus && event.getSource() == this._actionRedo) {
            this.redoLastAction();
        }
    }

    @Override
    public void undoableActionHappened(UndoableAction action) {
        if (this.hasFocus) {
            this.setMenus();
        }
    }

    private void setMenus() {
        UndoableAction undoAction = this.undoHandler.nextUndoAction();
        if (undoAction == null) {
            this._actionUndo.setText("Undo");
            this._actionUndo.setEnabled(false);
        } else {
            this._actionUndo.setText("Undo " + undoAction.getName());
            this._actionUndo.setEnabled(true);
        }
        UndoableAction redoAction = this.undoHandler.nextRedoAction();
        if (redoAction == null) {
            this._actionRedo.setText("Redo");
            this._actionRedo.setEnabled(false);
        } else {
            this._actionRedo.setText("Redo " + redoAction.getName());
            this._actionRedo.setEnabled(true);
        }
    }

    private void undoLastAction() {
        this.undoHandler.undoLastAction();
        if (this.hasFocus) {
            this.setMenus();
        }
    }

    private void redoLastAction() {
        this.undoHandler.redoLastAction();
        if (this.hasFocus) {
            this.setMenus();
        }
    }

    public void setFocusGained() {
        this.hasFocus = true;
        this._actionUndo.addMenuActionListener(this);
        this._actionRedo.addMenuActionListener(this);
        this.setMenus();
    }

    public void setFocusLost() {
        this.hasFocus = false;
        this._actionUndo.removeMenuActionListener(this);
        this._actionRedo.removeMenuActionListener(this);
        this._actionUndo.setText("Undo");
        this._actionUndo.setEnabled(false);
        this._actionRedo.setText("Redo");
        this._actionRedo.setEnabled(false);
    }

    public void destroy() {
        this._actionUndo.removeMenuActionListener(this);
        this._actionRedo.removeMenuActionListener(this);
    }

    public UndoHandler getUndoHandler() {
        return this.undoHandler;
    }
}

